/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CommandCleanh {
    private static final Map<ServerPlayer, ItemStack[]> hotbarUndoMap = new HashMap<ServerPlayer, ItemStack[]>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cleanh").requires(source -> CommandCleanh.checkPermission(source))).executes(CommandCleanh::cleanHotbarSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder)).executes(context -> CommandCleanh.cleanHotbarOther((CommandContext<CommandSourceStack>)context, Collections.singletonList(StringArgumentType.getString((CommandContext)context, (String)"player"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cleanhundo").requires(source -> CommandCleanh.checkPermission(source))).executes(CommandCleanh::undoHotbarSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder)).executes(context -> CommandCleanh.undoHotbarOther((CommandContext<CommandSourceStack>)context, Collections.singletonList(StringArgumentType.getString((CommandContext)context, (String)"player"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opCleanh.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int cleanHotbarSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CommandCleanh.saveHotbar(player);
        CommandCleanh.cleanHotbar(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Cleared your hotbar.")));
        return 1;
    }

    private static int cleanHotbarOther(CommandContext<CommandSourceStack> context, Collection<String> targets) {
        for (String target : targets) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(target);
            if (player != null) {
                CommandCleanh.saveHotbar(player);
                CommandCleanh.cleanHotbar(player);
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Cleared " + playerColor + target + standardColor + "'s hotbar.")));
                continue;
            }
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(errorColor + "Player " + target + " not found.")));
        }
        return 1;
    }

    private static void saveHotbar(ServerPlayer player) {
        ItemStack[] hotbarItems = new ItemStack[9];
        Inventory inventory = player.getInventory();
        for (int i = 0; i < 9; ++i) {
            hotbarItems[i] = inventory.getItem(i).copy();
        }
        hotbarUndoMap.put(player, hotbarItems);
    }

    private static void cleanHotbar(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < 9; ++i) {
            inventory.setItem(i, ItemStack.EMPTY);
        }
        inventory.setChanged();
    }

    private static int undoHotbarSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CommandCleanh.restoreHotbar(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Your hotbar has been restored.")));
        return 1;
    }

    private static int undoHotbarOther(CommandContext<CommandSourceStack> context, Collection<String> targets) {
        for (String target : targets) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(target);
            if (player != null) {
                CommandCleanh.restoreHotbar(player);
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Restored " + playerColor + target + standardColor + "'s hotbar.")));
                continue;
            }
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(errorColor + "Player " + target + " not found.")));
        }
        return 1;
    }

    private static void restoreHotbar(ServerPlayer player) {
        ItemStack[] savedHotbar = hotbarUndoMap.get(player);
        if (savedHotbar != null) {
            Inventory inventory = player.getInventory();
            for (int i = 0; i < savedHotbar.length; ++i) {
                inventory.setItem(i, savedHotbar[i]);
            }
            inventory.setChanged();
        }
    }
}

