/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CommandClear {
    private static final Map<ServerPlayer, ItemStack[]> undoMap = new HashMap<ServerPlayer, ItemStack[]>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(source -> CommandClear.checkPermission(source))).executes(CommandClear::clearSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandClear::clearPlayer)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clearundo").requires(source -> CommandClear.checkPermission(source))).executes(CommandClear::undoSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandClear::undoPlayer)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opClear.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int clearSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        CommandClear.saveInventory(player);
        CommandClear.clearPlayerInventory(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Your inventory has been cleared.")));
        return 1;
    }

    private static int clearPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer != null) {
            CommandClear.saveInventory(targetPlayer);
            CommandClear.clearPlayerInventory(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Player " + playerName + "'s inventory has been cleared.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void saveInventory(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        ItemStack[] savedItems = new ItemStack[inventory.getContainerSize()];
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            savedItems[i] = inventory.getItem(i).copy();
        }
        undoMap.put(player, savedItems);
    }

    private static void clearPlayerInventory(ServerPlayer player) {
        player.getInventory().clearContent();
    }

    private static int undoSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        CommandClear.restoreInventory(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Your inventory has been restored.")));
        return 1;
    }

    private static int undoPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer != null) {
            CommandClear.restoreInventory(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Player " + playerName + "'s inventory has been restored.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void restoreInventory(ServerPlayer player) {
        ItemStack[] savedInventory = undoMap.get(player);
        if (savedInventory != null) {
            Inventory inventory = player.getInventory();
            for (int i = 0; i < savedInventory.length && i < inventory.getContainerSize(); ++i) {
                inventory.setItem(i, savedInventory[i]);
            }
            inventory.setChanged();
        }
    }
}

