/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class CommandDelete {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(source -> CommandDelete.checkPermission(source))).then(Commands.argument((String)"entityName", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandDelete::suggestLoadedEntities).executes(CommandDelete::deleteEntities)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opDelete.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int deleteEntities(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String entityName = StringArgumentType.getString(context, (String)"entityName");
        Identifier targetEntity = Identifier.tryParse((String)entityName);
        if (targetEntity == null || ForgeRegistries.ENTITY_TYPES.getValue(targetEntity) == null) {
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(errorColor + "Invalid entity name: " + entityName)));
            return 0;
        }
        int deletedCount = 0;
        MinecraftServer server = source.getServer();
        for (ServerLevel world : server.getAllLevels()) {
            ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
            for (Entity entity : world.getAllEntities()) {
                Identifier entityKey = EntityType.getKey((EntityType)entity.getType());
                if (entityKey == null || !entityKey.equals((Object)targetEntity)) continue;
                entitiesToRemove.add(entity);
            }
            deletedCount += entitiesToRemove.size();
            for (Entity entity : entitiesToRemove) {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String message = standardColor + "Deleted " + playerColor + deletedCount + standardColor + " entities of type '" + String.valueOf(targetEntity) + "'.";
        source.sendSystemMessage((Component)Component.literal((String)message));
        return deletedCount;
    }

    private static CompletableFuture<Suggestions> suggestLoadedEntities(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        HashSet<String> entityNames = new HashSet<String>();
        for (ServerLevel world : server.getAllLevels()) {
            for (Entity entity : world.getAllEntities()) {
                Identifier entityKey = EntityType.getKey((EntityType)entity.getType());
                if (entityKey == null) continue;
                entityNames.add(entityKey.toString());
            }
        }
        return SharedSuggestionProvider.suggest(entityNames, (SuggestionsBuilder)builder);
    }
}

