/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;

public class CommandEc {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ec").requires(source -> CommandEc.checkPermission(source))).executes(CommandEc::openOwnEnderChest)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandEc::openOtherEnderChest)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opEc.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int openOwnEnderChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        CommandEc.openEnderChest(player, player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Opened your EnderChest.")));
        return 1;
    }

    private static int openOtherEnderChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerLevel world = source.getLevel();
        ServerPlayer targetPlayer = world.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer != null) {
            CommandEc.openEnderChest(player, targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Opened EnderChest of " + playerName + ".")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void openEnderChest(ServerPlayer player, ServerPlayer targetPlayer) {
        final PlayerEnderChestContainer enderChest = targetPlayer.getEnderChestInventory();
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Ender Chest");
            }

            public ChestMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                return ChestMenu.threeRows((int)id, (Inventory)playerInventory, (Container)enderChest);
            }
        });
    }
}

