/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandFly {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest((String[])ServerLifecycleHooks.getCurrentServer().getPlayerNames(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fly").requires(source -> CommandFly.checkPermission(source))).executes(CommandFly::toggleOwnFlyMode)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(CommandFly::togglePlayerFlyMode)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opFly.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int toggleOwnFlyMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        CommandFly.toggleFlyMode(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Toggled fly mode for yourself.")));
        return 1;
    }

    private static int togglePlayerFlyMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer != null) {
            CommandFly.toggleFlyMode(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Toggled fly mode for " + playerName + ".")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void toggleFlyMode(ServerPlayer player) {
        boolean isFlying = player.getAbilities().flying;
        player.getAbilities().flying = !isFlying;
        player.getAbilities().mayfly = !isFlying;
        player.onUpdateAbilities();
        String message = !isFlying ? "Fly mode enabled." : "Fly mode disabled.";
        player.sendSystemMessage((Component)Component.literal((String)message));
    }
}

