/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class CommandGlow {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"glow").requires(source -> CommandGlow.checkPermission(source))).executes(CommandGlow::Glow));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opGlow.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int Glow(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemStack.isEmpty()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "You must be holding an item to apply the glow effect.")));
            return 0;
        }
        ItemEnchantments existingEnchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(existingEnchantments);
        Holder.Reference unbreaking = source.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.UNBREAKING);
        mutableEnchantments.set((Holder)unbreaking, 1);
        itemStack.set(DataComponents.ENCHANTMENTS, (Object)mutableEnchantments.toImmutable());
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "The item is now glowing.")));
        return 1;
    }
}

