/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandGm {
    private static final SuggestionProvider<CommandSourceStack> GAME_MODES = (context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"0", "1", "2", "3"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest((String[])ServerLifecycleHooks.getCurrentServer().getPlayerNames(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gm").requires(source -> CommandGm.checkPermission(source))).then(((RequiredArgumentBuilder)Commands.argument((String)"mode", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).suggests(GAME_MODES).executes(context -> CommandGm.changeGameMode((CommandContext<CommandSourceStack>)context, null))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(context -> CommandGm.changeGameMode((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opGm.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int changeGameMode(CommandContext<CommandSourceStack> context, String playerName) throws CommandSyntaxException {
        ServerPlayer targetPlayer;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int mode = IntegerArgumentType.getInteger(context, (String)"mode");
        GameType gameType = GameType.byId((int)mode);
        boolean isSelfChange = false;
        if (playerName != null) {
            targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
            if (targetPlayer == null) {
                String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.sendFailure((Component)Component.literal((String)(errorColor + "Player " + playerName + " not found.")));
                return 1;
            }
        } else {
            targetPlayer = source.getPlayerOrException();
            isSelfChange = true;
        }
        targetPlayer.setGameMode(gameType);
        String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        if (isSelfChange) {
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Changed your game mode to " + successColor + gameType.getName())));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Changed game mode to " + successColor + gameType.getName() + standardColor + " for " + playerColor + targetPlayer.getName().getString())));
        }
        return 1;
    }
}

