/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandHeal {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest((String[])ServerLifecycleHooks.getCurrentServer().getPlayerNames(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"heal").requires(source -> true)).executes(CommandHeal::healSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(CommandHeal::healPlayer)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opBack.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int healSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        CommandHeal.healPlayer(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "You have been healed.")));
        return 1;
    }

    private static int healPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer != null) {
            CommandHeal.healPlayer(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Player " + playerName + " has been healed.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void healPlayer(ServerPlayer player) {
        FoodData foodData = player.getFoodData();
        foodData.setFoodLevel(20);
        foodData.setSaturation(5.0f);
        player.setHealth(player.getMaxHealth());
        player.clearFire();
    }
}

