/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CommandHome {
    private static final Map<UUID, Map<String, BlockPos>> homes = new HashMap<UUID, Map<String, BlockPos>>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"homeadd").requires(source -> CommandHome.checkPermission(source))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(CommandHome::addHome)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").requires(source -> CommandHome.checkPermission(source))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(CommandHome.suggestHomes()).executes(CommandHome::teleportHome)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"homeremove").requires(source -> CommandHome.checkPermission(source))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(CommandHome.suggestHomes()).executes(CommandHome::removeHome)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opHome.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int addHome(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Failed to get player instance.")));
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"name");
        BlockPos playerPos = player.blockPosition();
        UUID playerUUID = player.getUUID();
        Map playerHomes = homes.computeIfAbsent(playerUUID, k -> new HashMap());
        if (playerHomes.containsKey(homeName)) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            player.sendSystemMessage((Component)Component.literal((String)(warningColor + "Home '" + homeName + "' already exists!")));
            return 0;
        }
        playerHomes.put(homeName, playerPos);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        player.sendSystemMessage((Component)Component.literal((String)(standardColor + "Home '" + playerColor + homeName + standardColor + "' added at " + playerColor + String.valueOf(playerPos))));
        return 1;
    }

    private static int teleportHome(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Failed to get player instance.")));
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"name");
        UUID playerUUID = player.getUUID();
        Map<String, BlockPos> playerHomes = homes.get(playerUUID);
        if (playerHomes != null && playerHomes.containsKey(homeName)) {
            BlockPos homePos = playerHomes.get(homeName);
            ServerLevel world = player.level();
            player.teleportTo((double)homePos.getX(), (double)homePos.getY(), (double)homePos.getZ());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            player.sendSystemMessage((Component)Component.literal((String)(standardColor + "Teleported to home '" + successColor + homeName + standardColor + "'")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            player.sendSystemMessage((Component)Component.literal((String)(warningColor + "Home '" + homeName + "' not found")));
        }
        return 1;
    }

    private static int removeHome(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Failed to get player instance.")));
            return 0;
        }
        String homeName = StringArgumentType.getString(context, (String)"name");
        UUID playerUUID = player.getUUID();
        Map<String, BlockPos> playerHomes = homes.get(playerUUID);
        if (playerHomes != null && playerHomes.remove(homeName) != null) {
            String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            player.sendSystemMessage((Component)Component.literal((String)(standardColor + "Home '" + playerColor + homeName + standardColor + "' removed")));
        } else {
            String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            player.sendSystemMessage((Component)Component.literal((String)(standardColor + "Home '" + playerColor + homeName + standardColor + "' not found")));
        }
        return 1;
    }

    private static SuggestionProvider<CommandSourceStack> suggestHomes() {
        return (context, builder) -> {
            ServerPlayer player;
            try {
                player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            }
            catch (Exception e) {
                return Suggestions.empty();
            }
            UUID playerUUID = player.getUUID();
            Map<String, BlockPos> playerHomes = homes.get(playerUUID);
            if (playerHomes != null) {
                playerHomes.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.buildFuture();
        };
    }
}

