/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.LevelResource;

public class CommandInventory {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type INV_LIST_TYPE = new TypeToken<List<Map<String, Object>>>(){}.getType();
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String INVENTORIES_FOLDER_NAME = "inventorys";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"inventory").requires(CommandInventory::checkPermission)).then(Commands.literal((String)"save").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandInventory.saveInventory((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"load").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandInventory.suggestInventoryNames((CommandContext<CommandSourceStack>)context, builder)).executes(ctx -> CommandInventory.loadInventory((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandInventory.suggestInventoryNames((CommandContext<CommandSourceStack>)context, builder)).executes(ctx -> CommandInventory.deleteInventory((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))));
    }

    private static int saveInventory(CommandSourceStack source, String name) {
        try {
            File file;
            ServerPlayer player = source.getPlayerOrException();
            File inventoryFolder = CommandInventory.getInventoryFolder(source.getServer().getWorldPath(LevelResource.ROOT).toFile());
            if (!inventoryFolder.exists()) {
                inventoryFolder.mkdirs();
            }
            if ((file = new File(inventoryFolder, String.valueOf(player.getUUID()) + "_" + name + ".inv")).exists()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.sendFailure((Component)Component.literal((String)(warningColor + "An inventory with this name already exists!")));
                return 0;
            }
            ArrayList<Map<String, Object>> serialized = new ArrayList<Map<String, Object>>();
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (stack.isEmpty()) continue;
                Map<String, Object> map = CommandInventory.serializeItemStack(stack);
                map.put("slot", i);
                serialized.add(map);
            }
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(serialized, (Appendable)writer);
            }
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.sendSystemMessage((Component)Component.literal((String)(successColor + "Inventory saved successfully!")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to get player: " + e.getMessage())));
            return 0;
        }
        catch (IOException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to save inventory: " + e.getMessage())));
            return 0;
        }
    }

    private static int loadInventory(CommandSourceStack source, String name) {
        try {
            List<Map> serialized;
            ServerPlayer player = source.getPlayerOrException();
            File inventoryFolder = CommandInventory.getInventoryFolder(source.getServer().getWorldPath(LevelResource.ROOT).toFile());
            File file = new File(inventoryFolder, String.valueOf(player.getUUID()) + "_" + name + ".inv");
            if (!file.exists()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.sendFailure((Component)Component.literal((String)(warningColor + "No inventory found with this name!")));
                return 0;
            }
            try (FileReader reader = new FileReader(file);){
                serialized = (List<Map>)GSON.fromJson((Reader)reader, INV_LIST_TYPE);
            }
            if (serialized == null) {
                serialized = Collections.emptyList();
            }
            Inventory inv = player.getInventory();
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                inv.setItem(i, ItemStack.EMPTY);
            }
            for (Map map : serialized) {
                int slot = -1;
                Object sObj = map.get("slot");
                if (sObj instanceof Number) {
                    slot = ((Number)sObj).intValue();
                } else if (sObj != null) {
                    try {
                        slot = Integer.parseInt(String.valueOf(sObj));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ItemStack stack = CommandInventory.deserializeItemStack(map);
                if (slot >= 0 && slot < inv.getContainerSize()) {
                    inv.setItem(slot, stack);
                    continue;
                }
                inv.add(stack);
            }
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.sendSystemMessage((Component)Component.literal((String)(successColor + "Inventory loaded successfully!")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to get player: " + e.getMessage())));
            return 0;
        }
        catch (IOException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to load inventory: " + e.getMessage())));
            return 0;
        }
    }

    private static int deleteInventory(CommandSourceStack source, String name) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            File inventoryFolder = CommandInventory.getInventoryFolder(source.getServer().getWorldPath(LevelResource.ROOT).toFile());
            File file = new File(inventoryFolder, String.valueOf(player.getUUID()) + "_" + name + ".inv");
            if (!file.exists()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.sendFailure((Component)Component.literal((String)(warningColor + "No inventory found with this name!")));
                return 0;
            }
            if (file.delete()) {
                String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
                source.sendSystemMessage((Component)Component.literal((String)(successColor + "Inventory deleted successfully!")));
                return 1;
            }
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to delete inventory!")));
            return 0;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to get player: " + e.getMessage())));
            return 0;
        }
    }

    private static Map<String, Object> serializeItemStack(ItemStack itemStack) {
        CustomData cd;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Identifier id = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        map.put("id", id == null ? "minecraft:air" : id.toString());
        map.put("count", itemStack.getCount());
        if (itemStack.has(DataComponents.CUSTOM_DATA) && (cd = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA)) != null) {
            map.put("tag", cd.copyTag().toString());
        }
        return map;
    }

    private static ItemStack deserializeItemStack(Map<String, Object> map) {
        int count = 1;
        Object countObj = map.get("count");
        if (countObj instanceof Number) {
            count = ((Number)countObj).intValue();
        } else if (countObj != null) {
            try {
                count = Integer.parseInt(String.valueOf(countObj));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String idStr = String.valueOf(map.get("id"));
        Identifier rl = Identifier.tryParse((String)idStr);
        if (rl == null) {
            rl = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"air");
        }
        Optional optRef = BuiltInRegistries.ITEM.get(rl);
        Holder holder = (Holder)optRef.orElseGet(() -> (Holder.Reference)BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getDefaultKey()).orElseThrow());
        ItemStack itemStack = new ItemStack(holder, count);
        if (map.containsKey("tag")) {
            try {
                String snbt = String.valueOf(map.get("tag"));
                CompoundTag tag = null;
                try {
                    Class<?> cls = Class.forName("net.minecraft.nbt.TagParser");
                    Method m = cls.getMethod("parseTag", String.class);
                    Object parsed = m.invoke(null, snbt);
                    if (parsed instanceof CompoundTag) {
                        tag = (CompoundTag)parsed;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (tag != null) {
                    itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of(tag));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemStack;
    }

    private static File getInventoryFolder(File worldFolder) {
        return new File(worldFolder, FOLDER_NAME + File.separator + INVENTORIES_FOLDER_NAME);
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opInventory.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static CompletableFuture<Suggestions> suggestInventoryNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        try {
            File[] files;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            File inventoryFolder = CommandInventory.getInventoryFolder(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
            if (inventoryFolder.exists() && inventoryFolder.isDirectory() && (files = inventoryFolder.listFiles()) != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".inv")) continue;
                    builder.suggest(file.getName().replace(String.valueOf(player.getUUID()) + "_", "").replace(".inv", ""));
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return builder.buildFuture();
    }
}

