/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class CommandInvsee {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"invsee").requires(source -> CommandInvsee.checkPermission(source))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandInvsee::openPlayerInventory)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"inv").requires(source -> CommandInvsee.checkPermission(source))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandInvsee::openPlayerInventory)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opInvsee.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int openPlayerInventory(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer != null) {
            ServerPlayer player = source.getPlayerOrException();
            CommandInvsee.openInventoryGui(player, targetPlayer);
        } else {
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(errorColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void openInventoryGui(ServerPlayer player, ServerPlayer targetPlayer) {
        int containerSize = targetPlayer.getInventory().getContainerSize();
        int rows = containerSize / 9;
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new InvseeContainer(MenuType.GENERIC_9x4, id, playerInventory, targetPlayer.getInventory(), rows), (Component)Component.translatable((String)targetPlayer.getName().getString())));
    }

    public static class InvseeContainer
    extends ChestMenu {
        private final Inventory targetInventory;

        protected InvseeContainer(MenuType<?> type, int id, Inventory playerInventory, Inventory targetInventory, int rows) {
            super(type, id, playerInventory, (Container)targetInventory, rows);
            this.targetInventory = targetInventory;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.addSlot(new Slot((Container)targetInventory, col + row * 9, 8 + col * 18, 18 + row * 18));
                }
            }
            for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
                this.addSlot(new Slot((Container)targetInventory, hotbarSlot, 8 + hotbarSlot * 18, 76 + (rows - 4) * 18));
            }
        }

        public boolean stillValid(Player playerEntity) {
            return true;
        }
    }
}

