/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.LevelResource;

public class CommandKit {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type KIT_MAP_TYPE = new TypeToken<Map<String, List<Map<String, Object>>>>(){}.getType();
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String KIT_FILE_NAME = "kits.json";
    private static final SuggestionProvider<CommandSourceStack> KIT_SUGGESTIONS = (context, builder) -> {
        File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
        Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
        kits.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kit").requires(source -> {
            if (((Boolean)Dateiverwaltung.opKit.get()).booleanValue()) {
                // empty if block
            }
            return true;
        })).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> CommandKit.createKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.literal((String)"give").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(KIT_SUGGESTIONS).executes(context -> CommandKit.giveKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(KIT_SUGGESTIONS).executes(context -> CommandKit.deleteKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name"))))));
    }

    private static int createKit(CommandContext<CommandSourceStack> context, String name) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
            Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
            if (kits == null) {
                kits = new HashMap<String, List<Map<String, Object>>>();
            }
            if (kits.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "A kit with that name already exists.")));
                return 0;
            }
            ArrayList<ItemStack> hotbarItems = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                hotbarItems.add(player.getInventory().getItem(i));
            }
            List serializedItems = hotbarItems.stream().map(CommandKit::serializeItemStack).collect(Collectors.toList());
            kits.put(name, serializedItems);
            CommandKit.saveKits(kitFile, kits);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(successColor + "Kit created successfully.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            System.err.println("Error in createKit: " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    private static int giveKit(CommandContext<CommandSourceStack> context, String name) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
            Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
            if (kits == null || !kits.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "No kit with that name exists.")));
                return 0;
            }
            List<Map<String, Object>> serializedItems = kits.get(name);
            int emptySlots = 0;
            for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
                ItemStack itemStack = player.getInventory().getItem(slot);
                if (!itemStack.isEmpty()) continue;
                ++emptySlots;
            }
            if (serializedItems.size() > emptySlots) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Not enough space in inventory.")));
                return 0;
            }
            for (Map<String, Object> serializedItem : serializedItems) {
                ItemStack item = CommandKit.deserializeItemStack(serializedItem);
                player.getInventory().add(item);
            }
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(successColor + "Kit given successfully.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            System.err.println("Error in giveKit: " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    private static int deleteKit(CommandContext<CommandSourceStack> context, String name) {
        try {
            File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
            Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
            if (kits == null || !kits.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "No kit with that name exists.")));
                return 0;
            }
            kits.remove(name);
            CommandKit.saveKits(kitFile, kits);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(successColor + "Kit deleted successfully.")));
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error in deleteKit: " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    private static File getKitFile(File worldFolder) {
        File kitFile;
        File modFolder = new File(worldFolder, FOLDER_NAME);
        if (!modFolder.exists()) {
            if (modFolder.mkdirs()) {
                System.out.println("Debug: Created mod folder - " + modFolder.getAbsolutePath());
            } else {
                System.err.println("Error: Could not create mod folder - " + modFolder.getAbsolutePath());
            }
        }
        if (!(kitFile = new File(modFolder, KIT_FILE_NAME)).exists()) {
            try {
                if (kitFile.createNewFile()) {
                    System.out.println("Debug: Created kit file - " + kitFile.getAbsolutePath());
                } else {
                    System.err.println("Error: Could not create kit file - " + kitFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                System.err.println("Error: IOException while creating kit file - " + e.getMessage());
                e.printStackTrace();
            }
        }
        return kitFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, List<Map<String, Object>>> loadKits(File kitFile) {
        if (!kitFile.exists()) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        try (FileReader reader = new FileReader(kitFile);){
            Map kits = (Map)GSON.fromJson((Reader)reader, KIT_MAP_TYPE);
            if (kits == null) {
                HashMap<String, List<Map<String, Object>>> hashMap = new HashMap<String, List<Map<String, Object>>>();
                return hashMap;
            }
            Map map = kits;
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap<String, List<Map<String, Object>>>();
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            return new HashMap<String, List<Map<String, Object>>>();
        }
    }

    private static void saveKits(File kitFile, Map<String, List<Map<String, Object>>> kits) {
        try (FileWriter writer = new FileWriter(kitFile);){
            GSON.toJson(kits, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItemStack(ItemStack itemStack) {
        CustomData cd;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
        map.put("count", itemStack.getCount());
        try {
            Object var2_2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (itemStack.has(DataComponents.CUSTOM_DATA) && (cd = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA)) != null) {
            map.put("tag", cd.copyTag().toString());
        }
        return map;
    }

    private static ItemStack deserializeItemStack(Map<String, Object> map) {
        int count;
        Object countObj = map.get("count");
        if (countObj instanceof Number) {
            count = ((Number)countObj).intValue();
        } else {
            try {
                count = Integer.parseInt(String.valueOf(countObj));
            }
            catch (Exception e) {
                count = 1;
            }
        }
        String idStr = String.valueOf(map.get("id"));
        Identifier rl = Identifier.tryParse((String)idStr);
        if (rl == null) {
            int idx = idStr.indexOf(":");
            rl = idx < 0 ? Identifier.fromNamespaceAndPath((String)"minecraft", (String)idStr) : Identifier.fromNamespaceAndPath((String)idStr.substring(0, idx), (String)idStr.substring(idx + 1));
        }
        Optional optRef = BuiltInRegistries.ITEM.get(rl);
        Holder holder = (Holder)optRef.orElseGet(() -> (Holder.Reference)BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getDefaultKey()).orElseThrow());
        ItemStack itemStack = new ItemStack(holder, count);
        if (map.containsKey("tag")) {
            try {
                String snbt = map.get("tag").toString();
                CompoundTag tag = null;
                try {
                    Class<?> cls = Class.forName("net.minecraft.nbt.TagParser");
                    Method m = cls.getMethod("parseTag", String.class);
                    Object parsed = m.invoke(null, snbt);
                    if (parsed instanceof CompoundTag) {
                        tag = (CompoundTag)parsed;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (tag != null) {
                    itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of(tag));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return itemStack;
    }
}

