/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class CommandPay {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ONLINE_PLAYERS = (context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pay").requires(source -> CommandPay.checkPermission(source))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ONLINE_PLAYERS).then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> {
            ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            double amount = DoubleArgumentType.getDouble((CommandContext)context, (String)"amount");
            ServerPlayer target = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(targetName);
            if (target != null) {
                if (CommandPay.hasEnoughBalance(sender, amount)) {
                    CommandPay.adjustBalance(sender, -amount);
                    CommandPay.adjustBalance(target, amount);
                    String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                    String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                    String senderColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.sendername.get());
                    sender.sendSystemMessage((Component)Component.literal((String)(standardColor + "You paid " + senderColor + amount + standardColor + " to " + playerColor + target.getName().getString())));
                    target.sendSystemMessage((Component)Component.literal((String)(standardColor + "You received " + senderColor + amount + standardColor + " from " + playerColor + sender.getName().getString())));
                } else {
                    String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                    sender.sendSystemMessage((Component)Component.literal((String)(warningColor + "Not enough money.")));
                }
            } else {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                sender.sendSystemMessage((Component)Component.literal((String)(warningColor + "Player not found.")));
            }
            return 1;
        }))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opPay.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static boolean hasEnoughBalance(ServerPlayer player, double amount) {
        File bankFile = CommandPay.getBankFile(player);
        try {
            String content = new String(Files.readAllBytes(bankFile.toPath()));
            double balance = Double.parseDouble(content);
            return balance >= amount;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void adjustBalance(ServerPlayer player, double amount) {
        File bankFile = CommandPay.getBankFile(player);
        try {
            String content = new String(Files.readAllBytes(bankFile.toPath()));
            double balance = Double.parseDouble(content);
            balance += amount;
            try (FileWriter writer = new FileWriter(bankFile);){
                writer.write(Double.toString(balance));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getBankFile(ServerPlayer player) {
        File worldFolder = player.level().getServer().getWorldPath(LevelResource.ROOT).toFile();
        File modFolder = new File(worldFolder, "sarosessentialsmod/bank");
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        return new File(modFolder, player.getUUID().toString() + ".bank");
    }
}

