/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class CommandRename {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rename").requires(source -> CommandRename.checkPermission(source))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(CommandRename::renameItem)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opRain.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int renameItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack itemStack;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String newName = StringArgumentType.getString(context, (String)"name");
        ItemStack itemStack2 = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemStack2.isEmpty()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "You must hold an item in your main hand to rename it.")));
            return 0;
        }
        if (player instanceof LivingEntity) {
            ServerPlayer _livEnt = player;
            itemStack = _livEnt.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)newName));
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playernameColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Item renamed to: " + playernameColor + newName)));
        return 1;
    }
}

