/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;

public class CommandSetlore {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setlore").requires(source -> true)).then(Commands.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(CommandSetlore.suggestLines()).then(Commands.argument((String)"lore", (ArgumentType)StringArgumentType.string()).executes(CommandSetlore::setLore))));
    }

    private static SuggestionProvider<CommandSourceStack> suggestLines() {
        return (context, builder) -> {
            ServerPlayer player;
            try {
                player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            }
            catch (CommandSyntaxException e) {
                return CompletableFuture.completedFuture(builder.build());
            }
            ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (itemStack.isEmpty() || !itemStack.has(DataComponents.LORE)) {
                return CompletableFuture.completedFuture(builder.build());
            }
            List loreList = ((ItemLore)itemStack.get(DataComponents.LORE)).lines();
            for (int i = 0; i < loreList.size(); ++i) {
                builder.suggest(i);
            }
            return CompletableFuture.completedFuture(builder.build());
        };
    }

    private static int setLore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        int line = IntegerArgumentType.getInteger(context, (String)"line");
        String newLore = StringArgumentType.getString(context, (String)"lore");
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemStack.isEmpty()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "You must hold an item in your main hand to set lore.")));
            return 0;
        }
        if (!itemStack.has(DataComponents.LORE)) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "This item has no lore to edit use /addlore.")));
            return 0;
        }
        ArrayList<MutableComponent> loreList = new ArrayList<MutableComponent>(((ItemLore)itemStack.get(DataComponents.LORE)).lines());
        if (line < 0 || line >= loreList.size()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Invalid line number use /addlore.")));
            return 0;
        }
        MutableComponent loreLine = Component.literal((String)newLore).withStyle(style -> style.withColor(0x808080));
        loreList.set(line, loreLine);
        itemStack.set(DataComponents.LORE, (Object)new ItemLore(loreList));
        String standard = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playername = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String success = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
        source.sendSystemMessage((Component)Component.literal((String)(standard + "Lore line " + playername + line + standard + " set to: " + success + newLore)));
        return 1;
    }
}

