/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.SpawnPoint;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class CommandSetspawn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setspawn").requires(CommandSetspawn::checkPermission)).executes(context -> CommandSetspawn.setSpawn((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSpawn.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int setSpawn(CommandSourceStack source) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            Vec3 position = player.position();
            Vec2 rotation = player.getRotationVector();
            String dimension = player.level().dimension().toString();
            Vector3d vector3dPosition = new Vector3d(position.x(), position.y(), position.z());
            Vector2f vector2fRotation = new Vector2f(rotation.x, rotation.y);
            SpawnPoint spawnPoint = new SpawnPoint(dimension, vector3dPosition, vector2fRotation);
            CommandSetspawn.saveSpawnPoint(source, spawnPoint);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.sendSystemMessage((Component)Component.literal((String)(successColor + "Spawn point set successfully!")));
            return 1;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to set spawn point: " + e.getMessage())));
            return 0;
        }
    }

    private static void saveSpawnPoint(CommandSourceStack source, SpawnPoint spawnPoint) throws IOException {
        File worldFolder = source.getServer().getWorldPath(LevelResource.ROOT).resolve("sarosessentialsmod").toFile();
        if (!worldFolder.exists() && !worldFolder.mkdirs()) {
            throw new IOException("Could not create directory: " + String.valueOf(worldFolder));
        }
        File spawnFile = new File(worldFolder, "spawn.info");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(spawnFile);){
            gson.toJson((Object)spawnPoint, (Appendable)writer);
        }
    }
}

