/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;

public class CommandSkull {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skull").requires(source -> {
            if (((Boolean)Dateiverwaltung.opSkull.get()).booleanValue()) {
                // empty if block
            }
            return true;
        })).executes(CommandSkull::giveOwnHead)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandSkull::givePlayerHead)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"head").requires(source -> {
            if (((Boolean)Dateiverwaltung.opSkull.get()).booleanValue()) {
                // empty if block
            }
            return true;
        })).executes(CommandSkull::giveOwnHead)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder)).executes(CommandSkull::givePlayerHead)));
    }

    private static int giveOwnHead(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        CommandSkull.givePlayerHead(player, player.getGameProfile().name());
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Given your head.")));
        return 1;
    }

    private static int givePlayerHead(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String playerName = StringArgumentType.getString(context, (String)"player");
        CommandSkull.givePlayerHead(player, playerName);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Given head of " + playerName + ".")));
        return 1;
    }

    private static void givePlayerHead(ServerPlayer player, String playerName) {
        ItemStack skull = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        UUID playerUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes());
        CompoundTag profileTag = new CompoundTag();
        profileTag.putString("Name", playerName);
        profileTag.putIntArray("Id", new int[]{(int)(playerUUID.getMostSignificantBits() >> 32), (int)playerUUID.getMostSignificantBits(), (int)(playerUUID.getLeastSignificantBits() >> 32), (int)playerUUID.getLeastSignificantBits()});
        CompoundTag skullOwnerTag = new CompoundTag();
        skullOwnerTag.put("SkullOwner", (Tag)profileTag);
        skull.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)skullOwnerTag));
        player.addItem(skull);
    }
}

