/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.SpawnPoint;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class CommandSpawn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(CommandSpawn::checkPermission)).executes(context -> CommandSpawn.teleportToSpawn((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSpawn.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int teleportToSpawn(CommandSourceStack source) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            SpawnPoint spawnPoint = CommandSpawn.loadSpawnPoint(source);
            if (spawnPoint == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.sendFailure((Component)Component.literal((String)(warningColor + "No spawn point set!")));
                return 0;
            }
            ServerLevel world = source.getServer().getLevel(ServerLevel.OVERWORLD);
            if (world == null || !world.dimension().toString().equals(spawnPoint.dimension)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.sendFailure((Component)Component.literal((String)(warningColor + "Invalid spawn point dimension!")));
                return 0;
            }
            player.teleportTo(spawnPoint.position.x, spawnPoint.position.y, spawnPoint.position.z);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.sendSystemMessage((Component)Component.literal((String)(successColor + "Teleported to spawn point!")));
            return 1;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "Failed to teleport to spawn point: " + e.getMessage())));
            return 0;
        }
    }

    private static SpawnPoint loadSpawnPoint(CommandSourceStack source) throws IOException {
        File worldFolder = source.getServer().getWorldPath(LevelResource.ROOT).resolve("sarosessentialsmod").toFile();
        File spawnFile = new File(worldFolder, "spawn.info");
        if (!spawnFile.exists()) {
            return null;
        }
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(spawnFile);){
            SpawnPoint spawnPoint = (SpawnPoint)gson.fromJson((Reader)reader, SpawnPoint.class);
            return spawnPoint;
        }
    }
}

