/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandSudo {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sudo").requires(source -> CommandSudo.checkPermission(source))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            List players = server.getPlayerList().getPlayers();
            for (ServerPlayer player : players) {
                builder.suggest(player.getName().getString());
            }
            return builder.buildFuture();
        }).then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandSudo.executeSudo((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"command"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSudo.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int executeSudo(CommandContext<CommandSourceStack> context, String playerName, String command) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Player not found: " + playerName)));
            return 0;
        }
        server.getCommands().performCommand(server.getCommands().getDispatcher().parse(command, (Object)player.createCommandSourceStack()), command);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Executed command: /" + successColor + command + standardColor + " as " + playerColor + playerName)));
        return 1;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandSudo.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

