/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.command.CommandTpa;
import de.sarocesch.sarosessentialsmod.command.CommandTpahere;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandTpaaccept {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaaccept").requires(source -> CommandTpaaccept.checkPermission(source))).executes(context -> {
            ServerPlayer target = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            HashMap<UUID, UUID> tpaRequests = CommandTpa.getTpaRequests();
            HashMap<UUID, UUID> tpahereRequests = CommandTpahere.getTpahereRequests();
            if (tpaRequests.containsKey(target.getUUID())) {
                UUID senderUUID = tpaRequests.remove(target.getUUID());
                ServerPlayer sender = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(senderUUID);
                if (sender != null) {
                    sender.teleportTo(target.getX(), target.getY(), target.getX());
                    String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                    String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                    sender.sendSystemMessage((Component)Component.literal((String)(standardColor + "TPA request accepted. Teleporting to " + playerColor + target.getName().getString())));
                    target.sendSystemMessage((Component)Component.literal((String)(standardColor + "You accepted the TPA request from " + playerColor + sender.getName().getString())));
                }
            } else if (tpahereRequests.containsKey(target.getUUID())) {
                UUID senderUUID = tpahereRequests.remove(target.getUUID());
                ServerPlayer sender = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(senderUUID);
                if (sender != null) {
                    sender.teleportTo(sender.getX(), sender.getY(), sender.getX());
                    String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                    String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                    target.sendSystemMessage((Component)Component.literal((String)(standardColor + "TPA here request accepted. Teleporting to " + playerColor + sender.getName().getString())));
                    sender.sendSystemMessage((Component)Component.literal((String)(standardColor + "Your TPA here request was accepted by " + playerColor + target.getName().getString())));
                }
            } else {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                target.sendSystemMessage((Component)Component.literal((String)(warningColor + "No pending TPA requests.")));
            }
            return 1;
        }));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTpa.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }
}

