/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class CommandTpahere {
    private static final HashMap<UUID, UUID> tpahereRequests = new HashMap();
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ONLINE_PLAYERS = (context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpahere").requires(source -> CommandTpahere.checkPermission(source))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ONLINE_PLAYERS).executes(context -> {
            ServerPlayer sender = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            ServerPlayer target = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(targetName);
            if (target != null) {
                tpahereRequests.put(target.getUUID(), sender.getUUID());
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                MutableComponent message = Component.literal((String)(playerColor + sender.getName().getString() + standardColor + " has sent you a TPA here request. "));
                Style acceptStyle = Style.EMPTY.withColor(ChatFormatting.GREEN);
                MutableComponent acceptButton = Component.literal((String)"[Accept]").withStyle(acceptStyle);
                Style denyStyle = Style.EMPTY.withColor(ChatFormatting.RED);
                MutableComponent denyButton = Component.literal((String)"[Deny]").withStyle(denyStyle);
                message.append((Component)acceptButton).append(" ").append((Component)denyButton);
                target.sendSystemMessage((Component)message);
                target.sendSystemMessage((Component)Component.literal((String)"/tpaaccept").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN).withBold(Boolean.valueOf(true))));
                target.sendSystemMessage((Component)Component.literal((String)"/tpadeny").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_RED).withBold(Boolean.valueOf(true))));
                sender.sendSystemMessage((Component)Component.literal((String)(standardColor + "TPA here request sent to " + playerColor + targetName)));
            } else {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                sender.sendSystemMessage((Component)Component.literal((String)(warningColor + "Player not found.")));
            }
            return 1;
        })));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTpa.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public static HashMap<UUID, UUID> getTpahereRequests() {
        return tpahereRequests;
    }
}

