/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CommandTpall {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpall").requires(source -> CommandTpall.checkPermission(source))).executes(CommandTpall::execute));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTpall.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        ServerPlayer playerExecuting;
        try {
            playerExecuting = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "You must be a player to use this command.")));
            return 0;
        }
        List players = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers();
        for (ServerPlayer playerToTeleport : players) {
            if (playerToTeleport == playerExecuting) continue;
            CommandTpall.teleportPlayer(playerExecuting, playerToTeleport);
        }
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "All players have been teleported.")));
        return 1;
    }

    private static void teleportPlayer(ServerPlayer targetPlayer, ServerPlayer playerToTeleport) {
        ServerLevel targetWorld = targetPlayer.level();
        playerToTeleport.teleportTo(targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ());
    }
}

