/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CommandTphere {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tphere").requires(source -> CommandTphere.checkPermission(source))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(CommandTphere::suggestPlayers).executes(CommandTphere::execute)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTphere.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List players = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            builder.suggest(player.getName().getString());
        }
        return builder.buildFuture();
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer playerExecuting = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String playerName = StringArgumentType.getString(context, (String)"player");
            ServerPlayer playerToTeleport = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
            if (playerToTeleport == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Player not found.")));
                return 0;
            }
            CommandTphere.teleportPlayer(playerExecuting, playerToTeleport);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Teleported " + playerColor + playerName + standardColor + " to you.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "You must be a player to use this command.")));
            return 0;
        }
    }

    private static void teleportPlayer(ServerPlayer targetPlayer, ServerPlayer playerToTeleport) {
        ServerLevel targetWorld = targetPlayer.level();
        playerToTeleport.teleportTo(targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ());
    }
}

