/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandTpoffline {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tpoffline").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).requires(source -> CommandTpoffline.checkPermission(source))).suggests((context, builder) -> {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            server.getPlayerList().getPlayers().stream().filter(player -> !player.connection.getConnection().isConnected()).forEach(player -> builder.suggest(player.getName().getString()));
            return builder.buildFuture();
        }).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(playerName);
            if (targetPlayer == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Player not found or is online.")));
                return 0;
            }
            ServerLevel world = targetPlayer.level();
            BlockPos pos = targetPlayer.blockPosition();
            ((CommandSourceStack)context.getSource()).getPlayerOrException().teleportTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Teleported to " + playerName)));
            return 1;
        })));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTpoffline.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandTpoffline.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

