/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;

public class CommandTrash {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trash").requires(source -> CommandTrash.checkPermission(source))).executes(context -> CommandTrash.openTrash((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(CommandTrash::suggestPlayers).executes(context -> CommandTrash.openTrash((CommandContext<CommandSourceStack>)context, CommandTrash.getPlayerByName((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTphere.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List players = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            builder.suggest(player.getName().getString());
        }
        return builder.buildFuture();
    }

    private static ServerPlayer getPlayerByName(CommandContext<CommandSourceStack> context, String playerName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
        }
        return player;
    }

    private static int openTrash(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, playerIn) -> {
            TrashInventory trashInventory = new TrashInventory(27);
            return ChestMenu.threeRows((int)id, (Inventory)inv, (Container)trashInventory);
        }, (Component)Component.literal((String)"Trash")));
        return 1;
    }

    private static class TrashInventory
    extends SimpleContainer {
        public TrashInventory(int size) {
            super(size);
        }
    }
}

