/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;

public class CommandUnbreakable {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unbreakable").requires(CommandUnbreakable::checkPermission)).executes(context -> CommandUnbreakable.makeItemUnbreakable((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opUnbreakable.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int makeItemUnbreakable(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.isEmpty()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "You must hold an item in your hand to make it unbreakable.")));
            return 0;
        }
        itemStack.set(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "The item in your hand is now unbreakable.")));
        return 1;
    }
}

