/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandVanish {
    private static final Map<String, Boolean> vanishedPlayers = new HashMap<String, Boolean>();
    private static final SuggestionProvider<CommandSourceStack> PLAYER_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vanish").requires(source -> CommandVanish.checkPermission(source))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_SUGGESTIONS).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getTextName())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"v").requires(source -> CommandVanish.checkPermission(source))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_SUGGESTIONS).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getTextName())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opVanish.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int toggleVanish(CommandContext<CommandSourceStack> context, String playerName) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Player not found")));
            return 0;
        }
        boolean isVanished = vanishedPlayers.getOrDefault(playerName, false);
        if (isVanished) {
            player.setInvisible(false);
            vanishedPlayers.put(playerName, false);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + playerName + " is now visible")));
        } else {
            player.setInvisible(true);
            vanishedPlayers.put(playerName, true);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + playerName + " is now invisible")));
        }
        return 1;
    }
}

