/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.command.CommandSetwarp;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class CommandWarp {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type WARP_MAP_TYPE = new TypeToken<Map<String, CommandSetwarp.Warp>>(){}.getType();
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String WARP_FILE_NAME = "warps.json";
    private static final SuggestionProvider<CommandSourceStack> WARP_SUGGESTIONS = (context, builder) -> {
        File warpFile = CommandWarp.getWarpFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
        Map<String, CommandSetwarp.Warp> warps = CommandWarp.loadWarps(warpFile);
        return SharedSuggestionProvider.suggest(warps.keySet(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warp").requires(source -> CommandWarp.checkPermission(source))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(WARP_SUGGESTIONS).executes(context -> CommandWarp.warpToLocation((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opWarp.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int warpToLocation(CommandContext<CommandSourceStack> context, String name) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            File warpFile = CommandWarp.getWarpFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
            Map<String, CommandSetwarp.Warp> warps = CommandWarp.loadWarps(warpFile);
            if (!warps.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "No warp with that name exists.")));
                return 0;
            }
            CommandSetwarp.Warp warp = warps.get(name);
            player.teleportTo((double)warp.getPosition().getX(), (double)warp.getPosition().getY(), (double)warp.getPosition().getZ());
            player.setYHeadRot(warp.getYaw());
            player.setXRot(warp.getPitch());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Warped to " + playerColor + name + standardColor + " successfully.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "CommandSyntaxException: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Exception: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static File getWarpFile(File worldFolder) {
        File warpFile;
        File modFolder = new File(worldFolder, FOLDER_NAME);
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        if (!(warpFile = new File(modFolder, WARP_FILE_NAME)).exists()) {
            try {
                warpFile.createNewFile();
                try (FileWriter writer = new FileWriter(warpFile);){
                    writer.write("{}");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return warpFile;
    }

    private static Map<String, CommandSetwarp.Warp> loadWarps(File warpFile) {
        Map map;
        if (!warpFile.exists()) {
            return new HashMap<String, CommandSetwarp.Warp>();
        }
        FileReader reader = new FileReader(warpFile);
        try {
            map = (Map)GSON.fromJson((Reader)reader, WARP_MAP_TYPE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HashMap<String, CommandSetwarp.Warp>();
            }
        }
        reader.close();
        return map;
    }
}

