/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelResource;

public class CommandWarps {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type WARP_MAP_TYPE = new TypeToken<Map<String, Warp>>(){}.getType();
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String WARP_FILE_NAME = "warps.json";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warps").requires(source -> CommandWarps.checkPermission(source))).executes(CommandWarps::listWarps));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opWarp.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int listWarps(CommandContext<CommandSourceStack> context) {
        try {
            File warpFile = CommandWarps.getWarpFile(((CommandSourceStack)context.getSource()).getServer().getWorldPath(LevelResource.ROOT).toFile());
            Map<String, Warp> warps = CommandWarps.loadWarps(warpFile);
            if (warps.isEmpty()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "No warps set.")));
                return 0;
            }
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
            StringBuilder warpList = new StringBuilder(standardColor + "Available Warps:" + playerColor + "\n");
            for (String warpName : warps.keySet()) {
                warpList.append(warpName).append("\n");
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)warpList.toString()));
            return 1;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "Exception: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static File getWarpFile(File worldFolder) {
        File warpFile;
        File modFolder = new File(worldFolder, FOLDER_NAME);
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        if (!(warpFile = new File(modFolder, WARP_FILE_NAME)).exists()) {
            try {
                warpFile.createNewFile();
                try (FileWriter writer = new FileWriter(warpFile);){
                    writer.write("{}");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return warpFile;
    }

    private static Map<String, Warp> loadWarps(File warpFile) {
        Map map;
        if (!warpFile.exists()) {
            return new HashMap<String, Warp>();
        }
        FileReader reader = new FileReader(warpFile);
        try {
            map = (Map)GSON.fromJson((Reader)reader, WARP_MAP_TYPE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HashMap<String, Warp>();
            }
        }
        reader.close();
        return map;
    }

    public static class Warp {
        private final String dimension;
        private final BlockPos position;
        private final float yaw;
        private final float pitch;

        public Warp(String dimension, BlockPos position, float yaw, float pitch) {
            this.dimension = dimension;
            this.position = position;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public String getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }
    }
}

