/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;

public class CommandWorkbench {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"workbench").requires(source -> CommandWorkbench.checkPermission(source))).executes(context -> CommandWorkbench.execute((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opWorkbench.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int execute(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.literal((String)"Only players can use this command!"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new WorkbenchCraftingMenu(containerId, playerInventory), (Component)Component.translatable((String)"container.crafting")));
        return 1;
    }

    private static class WorkbenchCraftingMenu
    extends CraftingMenu {
        private boolean isUpdating = false;
        private final ServerPlayer player;

        public WorkbenchCraftingMenu(int containerId, Inventory playerInventory) {
            super(containerId, playerInventory);
            this.player = (ServerPlayer)playerInventory.player;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void slotsChanged(Container container) {
            if (this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            try {
                ServerLevel level = this.player.level();
                if (!level.isClientSide()) {
                    TransientCraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
                    for (int i = 0; i < 9; ++i) {
                        craftSlots.setItem(i, this.getSlot(i + 1).getItem());
                    }
                }
            }
            finally {
                this.isUpdating = false;
            }
        }
    }
}

