/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.event;

import com.google.gson.Gson;
import de.sarocesch.sarosessentialsmod.SpawnPoint;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            try {
                ServerLevel world;
                SpawnPoint spawnPoint;
                if (((Boolean)Dateiverwaltung.teleportToSpawnOnJoin.get()).booleanValue() && (spawnPoint = EventHandler.loadSpawnPoint(player)) != null && (world = player.level().getServer().getLevel(ServerLevel.OVERWORLD)) != null && world.dimension().toString().equals(spawnPoint.dimension)) {
                    player.teleportTo(spawnPoint.position.x, spawnPoint.position.y, spawnPoint.position.z);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static SpawnPoint loadSpawnPoint(ServerPlayer player) throws IOException {
        File worldFolder = player.level().getServer().getWorldPath(LevelResource.ROOT).toFile();
        File spawnFile = new File(worldFolder, "sarosessentialsmod/spawn.info");
        if (!spawnFile.exists()) {
            return null;
        }
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(spawnFile);){
            SpawnPoint spawnPoint = (SpawnPoint)gson.fromJson((Reader)reader, SpawnPoint.class);
            return spawnPoint;
        }
    }
}

