/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace;

import com.google.common.collect.ImmutableSet;
import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.mixin.PoiTypeAccessor;
import de.cech12.brickfurnace.mixin.PoiTypesAccessor;
import de.cech12.brickfurnace.platform.Services;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CommonLoader {
    public static void init() {
        Services.CONFIG.init();
    }

    public static void initPoiStates(Function<ResourceKey<PoiType>, Optional<Holder.Reference<PoiType>>> poiTypeGetter) {
        CommonLoader.replacePoiStates(poiTypeGetter, (ResourceKey<PoiType>)PoiTypes.ARMORER, Constants.BRICK_BLAST_FURNACE_BLOCK.get());
        CommonLoader.replacePoiStates(poiTypeGetter, (ResourceKey<PoiType>)PoiTypes.BUTCHER, Constants.BRICK_SMOKER_BLOCK.get());
    }

    private static void replacePoiStates(Function<ResourceKey<PoiType>, Optional<Holder.Reference<PoiType>>> poiTypeGetter, ResourceKey<PoiType> poiTypeKey, Block addBlock) {
        poiTypeGetter.apply(poiTypeKey).ifPresent(poiType -> {
            HashSet addedStates = new HashSet(addBlock.getStateDefinition().getPossibleStates());
            HashSet<Object> newStates = new HashSet<Object>();
            newStates.addAll(((PoiTypeAccessor)poiType.value()).getMatchingStates());
            newStates.addAll(addedStates);
            ((PoiTypeAccessor)poiType.value()).setMatchingStates((Set<BlockState>)ImmutableSet.copyOf(newStates));
            addedStates.forEach(state -> PoiTypesAccessor.getBlockStateToPointOfInterestType().put((BlockState)state, (Holder<PoiType>)poiType));
        });
    }

    private CommonLoader() {
    }
}

