/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.blockentity;

import de.cech12.brickfurnace.platform.Services;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2363;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public abstract class AbstractBrickFurnaceBlockEntity
extends class_2609 {
    protected final class_3956<? extends class_1874> specificRecipeType;
    protected final class_3956<? extends class_1874> vanillaRecipeType;
    public static final int BURN_TIME = 0;
    public static final int RECIPES_USED = 1;
    public static final int COOK_TIME = 2;
    public static final int COOK_TIME_TOTAL = 3;
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    public static final int OUTPUT = 2;
    protected class_8786<? extends class_1874> curRecipe;
    protected class_1799 failedMatch = class_1799.field_8037;

    public AbstractBrickFurnaceBlockEntity(class_2591<?> blockEntityTypeIn, class_2338 blockPos, class_2680 blockState, class_3956<? extends class_1874> specificRecipeTypeIn, class_3956<? extends class_1874> vanillaRecipeTypeIn) {
        super(blockEntityTypeIn, blockPos, blockState, vanillaRecipeTypeIn);
        this.specificRecipeType = specificRecipeTypeIn;
        this.vanillaRecipeType = vanillaRecipeTypeIn;
    }

    private boolean isBurning() {
        return this.field_17374.method_17390(0) > 0;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AbstractBrickFurnaceBlockEntity entity) {
        boolean wasBurning = entity.isBurning();
        boolean dirty = false;
        if (entity.isBurning()) {
            entity.field_17374.method_17391(0, entity.field_17374.method_17390(0) - 1);
        }
        if (level == null || level.field_9236) {
            return;
        }
        class_1799 fuel = (class_1799)entity.field_11984.get(1);
        if (entity.isBurning() || !fuel.method_7960() && !((class_1799)entity.field_11984.get(0)).method_7960()) {
            class_8786<? extends class_1874> irecipe = entity.getRecipe();
            boolean valid = entity.canBurn(irecipe);
            if (!entity.isBurning() && valid) {
                entity.field_17374.method_17391(0, entity.method_11200(Objects.requireNonNull(level.method_8503()).method_62735(), fuel));
                entity.field_17374.method_17391(1, entity.field_17374.method_17390(0));
                if (entity.isBurning()) {
                    dirty = true;
                    if (Services.PLATFORM.hasCraftingRemainingItem(fuel)) {
                        entity.field_11984.set(1, (Object)Services.PLATFORM.getCraftingRemainingItem(fuel));
                    } else if (!fuel.method_7960()) {
                        fuel.method_7934(1);
                        if (fuel.method_7960()) {
                            entity.field_11984.set(1, (Object)Services.PLATFORM.getCraftingRemainingItem(fuel));
                        }
                    }
                }
            }
            if (entity.isBurning() && valid) {
                entity.field_17374.method_17391(2, entity.field_17374.method_17390(2) + 1);
                if (entity.field_17374.method_17390(2) == entity.field_17374.method_17390(3)) {
                    entity.field_17374.method_17391(2, 0);
                    entity.field_17374.method_17391(3, entity.getTotalCookTime(entity.getRecipe()));
                    entity.smeltItem(irecipe);
                    dirty = true;
                }
            } else {
                entity.field_17374.method_17391(2, 0);
            }
        } else if (!entity.isBurning() && entity.field_17374.method_17390(2) > 0) {
            entity.field_17374.method_17391(2, class_3532.method_15340((int)(entity.field_17374.method_17390(2) - 2), (int)0, (int)entity.field_17374.method_17390(3)));
        }
        if (wasBurning != entity.isBurning()) {
            dirty = true;
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(entity.isBurning())), 3);
        }
        if (dirty) {
            entity.method_5431();
        }
    }

    private boolean canBurn(@Nullable class_8786<?> recipe) {
        class_1874 cookingRecipe;
        class_1799 recipeOutput;
        class_1860 class_18602;
        if (this.method_10997() != null && !((class_1799)this.field_11984.getFirst()).method_7960() && recipe != null && (class_18602 = recipe.comp_1933()) instanceof class_1874 && !(recipeOutput = (cookingRecipe = (class_1874)class_18602).method_59998(new class_9696((class_1799)this.field_11984.getFirst()), (class_7225.class_7874)this.method_10997().method_30349())).method_7960()) {
            class_1799 output = (class_1799)this.field_11984.get(2);
            if (output.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)output, (class_1799)recipeOutput)) {
                return false;
            }
            return output.method_7947() + recipeOutput.method_7947() <= output.method_7914();
        }
        return false;
    }

    private void smeltItem(@Nullable class_8786<?> recipe) {
        class_1860 class_18602;
        if (this.method_10997() != null && recipe != null && (class_18602 = recipe.comp_1933()) instanceof class_1874) {
            class_1874 cookingRecipe = (class_1874)class_18602;
            if (this.canBurn(recipe)) {
                class_1799 itemstack = (class_1799)this.field_11984.get(0);
                class_1799 itemstack1 = cookingRecipe.method_59998(new class_9696((class_1799)this.field_11984.getFirst()), (class_7225.class_7874)this.method_10997().method_30349());
                class_1799 itemstack2 = (class_1799)this.field_11984.get(2);
                if (itemstack2.method_7960()) {
                    this.field_11984.set(2, (Object)itemstack1.method_7972());
                } else if (itemstack2.method_7909() == itemstack1.method_7909()) {
                    itemstack2.method_7933(itemstack1.method_7947());
                }
                if (this.field_11863 != null && !this.field_11863.field_9236) {
                    this.method_7662(recipe);
                }
                if (itemstack.method_7909() == class_2246.field_10562.method_8389() && !((class_1799)this.field_11984.get(1)).method_7960() && ((class_1799)this.field_11984.get(1)).method_7909() == class_1802.field_8550) {
                    this.field_11984.set(1, (Object)new class_1799((class_1935)class_1802.field_8705));
                }
                itemstack.method_7934(1);
            }
        }
    }

    private int getTotalCookTime(class_8786<? extends class_1874> rec) {
        if (rec == null) {
            return 200;
        }
        if (this.specificRecipeType.getClass().isInstance(((class_1874)rec.comp_1933()).method_17716())) {
            return ((class_1874)rec.comp_1933()).method_8167();
        }
        return (int)((double)((class_1874)rec.comp_1933()).method_8167() * Services.CONFIG.getCookTimeFactor());
    }

    public class_8786<? extends class_1874> getRecipe() {
        class_1799 input = this.method_5438(0);
        if (input.method_7960() || input == this.failedMatch) {
            return null;
        }
        class_9696 recipeInput = new class_9696(input);
        if (this.field_11863 != null && this.curRecipe != null && ((class_1874)this.curRecipe.comp_1933()).method_64719(recipeInput, this.field_11863)) {
            this.field_17374.method_17391(3, this.getTotalCookTime(this.curRecipe));
            return this.curRecipe;
        }
        class_8786 rec = null;
        if (this.field_11863 != null && this.field_11863.method_8503() != null && (rec = (class_8786)this.field_11863.method_8503().method_3772().method_8132(this.specificRecipeType, (class_9695)recipeInput, this.field_11863).orElse(null)) == null && Services.CONFIG.areVanillaRecipesEnabled()) {
            rec = this.field_11863.method_8503().method_3772().method_8126().stream().filter(recipe -> recipe.comp_1933().method_17716() == this.vanillaRecipeType).filter(recipe -> recipe.comp_1933() instanceof class_1874).map(recipe -> recipe).filter(recipe -> ((class_1874)recipe.comp_1933()).method_64719(recipeInput, this.field_11863)).filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.comp_1932().method_29177())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : class_1799.field_8037;
        this.field_17374.method_17391(3, this.getTotalCookTime(rec));
        this.curRecipe = rec;
        return this.curRecipe;
    }

    public class_3913 getContainerData() {
        return this.field_17374;
    }
}

