/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.platform;

import de.cech12.brickfurnace.platform.services.IConfigHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;

@Config(name="brickfurnace")
public class FabricConfigHelper
implements ConfigData,
IConfigHelper {
    @ConfigEntry.Gui.Tooltip(count=4)
    public boolean VANILLA_RECIPES_ENABLED = true;
    @ConfigEntry.Gui.Tooltip(count=6)
    public long COOK_TIME_FACTOR = 100L;
    @ConfigEntry.Gui.Tooltip(count=5)
    public String RECIPE_BLOCKED_LIST = "";

    @Override
    public void init() {
        AutoConfig.register(FabricConfigHelper.class, Toml4jConfigSerializer::new);
    }

    private FabricConfigHelper getConfig() {
        return (FabricConfigHelper)AutoConfig.getConfigHolder(FabricConfigHelper.class).getConfig();
    }

    @Override
    public boolean areVanillaRecipesEnabled() {
        return this.getConfig().VANILLA_RECIPES_ENABLED;
    }

    @Override
    public double getCookTimeFactor() {
        return Math.clamp((double)this.getConfig().COOK_TIME_FACTOR / 100.0, 0.0, 100.0);
    }

    @Override
    public String getRecipeBlockedList() {
        return this.getConfig().RECIPE_BLOCKED_LIST;
    }
}

