/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace;

import de.cech12.brickfurnace.CommonLoader;
import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.init.ModBlockEntityTypes;
import de.cech12.brickfurnace.init.ModBlocks;
import de.cech12.brickfurnace.init.ModItems;
import de.cech12.brickfurnace.init.ModRecipeTypes;
import de.cech12.brickfurnace.mixin.PoiTypeAccessor;
import de.cech12.brickfurnace.mixin.PoiTypesAccessor;
import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="brickfurnace")
@Mod.EventBusSubscriber(modid="brickfurnace", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BrickFurnaceMod {
    public BrickFurnaceMod(FMLJavaModLoadingContext context) {
        BusGroup eventBus = context.getModBusGroup();
        ModBlocks.BLOCKS.register(eventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModRecipeTypes.RECIPE_TYPES.register(eventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(eventBus);
        CommonLoader.init();
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        if (ForgeRegistries.POI_TYPES.equals((Object)event.getForgeRegistry())) {
            event.register(ForgeRegistries.Keys.POI_TYPES, pointOfInterestTypeRegisterHelper -> {
                HashSet addedStates = new HashSet(Constants.BRICK_BLAST_FURNACE_BLOCK.get().getStateDefinition().getPossibleStates());
                HashSet<Object> newStates = new HashSet<Object>();
                newStates.addAll(((PoiTypeAccessor)ForgeRegistries.POI_TYPES.getValue(PoiTypes.ARMORER.location())).getMatchingStates());
                newStates.addAll(addedStates);
                PoiType pointOfInterestType = new PoiType(newStates, 1, 1);
                ForgeRegistries.POI_TYPES.register("minecraft:armorer", (Object)pointOfInterestType);
                PoiTypesAccessor.setArmorer((ResourceKey<PoiType>)((ResourceKey)((Holder)ForgeRegistries.POI_TYPES.getHolder((Object)pointOfInterestType).get()).unwrapKey().get()));
                addedStates = new HashSet(Constants.BRICK_SMOKER_BLOCK.get().getStateDefinition().getPossibleStates());
                newStates = new HashSet();
                newStates.addAll(((PoiTypeAccessor)ForgeRegistries.POI_TYPES.getValue(PoiTypes.BUTCHER.location())).getMatchingStates());
                newStates.addAll(addedStates);
                pointOfInterestType = new PoiType(newStates, 1, 1);
                ForgeRegistries.POI_TYPES.register("minecraft:butcher", (Object)pointOfInterestType);
                PoiTypesAccessor.setButcher((ResourceKey<PoiType>)((ResourceKey)((Holder)ForgeRegistries.POI_TYPES.getHolder((Object)pointOfInterestType).get()).unwrapKey().get()));
            });
        }
    }

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept(Constants.BRICK_FURNACE_ITEM);
            event.accept(Constants.BRICK_BLAST_FURNACE_ITEM);
            event.accept(Constants.BRICK_SMOKER_ITEM);
        }
    }
}

