/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.platform;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.cech12.brickfurnace.platform.services.IConfigHelper;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeConfigHelper
implements IConfigHelper {
    private static final ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.BooleanValue VANILLA_RECIPES_ENABLED;
    public static final ForgeConfigSpec.DoubleValue COOK_TIME_FACTOR;
    public static final ForgeConfigSpec.ConfigValue<String> RECIPE_BLOCKED_LIST;

    @Override
    public void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        Path path = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("brickfurnace-server.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        SERVER_CONFIG.setConfig((CommentedConfig)configData);
    }

    @Override
    public boolean areVanillaRecipesEnabled() {
        try {
            return (Boolean)VANILLA_RECIPES_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    @Override
    public double getCookTimeFactor() {
        try {
            return (Double)COOK_TIME_FACTOR.get();
        }
        catch (IllegalStateException ex) {
            return 1.0;
        }
    }

    @Override
    public String getRecipeBlockedList() {
        try {
            return (String)RECIPE_BLOCKED_LIST.get();
        }
        catch (IllegalStateException ex) {
            return "";
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Options that affect the added furnaces.").push("Furnace Settings");
        VANILLA_RECIPES_ENABLED = builder.comment("If enabled, the vanilla blasting, smelting, and smoking recipes are used by the brick furnaces.").define("vanillaRecipesEnabled", true);
        COOK_TIME_FACTOR = builder.comment("Cook time factor of all added brick furnaces in relation to corresponding vanilla furnaces. (i. e. 0.5 - half the time, 1.0 same time, 2.0 twice the time)").defineInRange("cookTimeFactor", 1.0, 0.0, 100.0);
        RECIPE_BLOCKED_LIST = builder.comment("A comma separated list of all vanilla recipes that should not be used by the brick furnaces. Example: \"baked_potato,baked_potato_from_smoking,othermod:other_baked_food\"").define("recipeBlockedList", (Object)"");
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

