/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.jei;

import de.cech12.brickfurnace.BrickFurnaceMod;
import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.crafting.BrickBlastingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmeltingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmokingRecipe;
import de.cech12.brickfurnace.jei.BrickBlastingCategory;
import de.cech12.brickfurnace.jei.BrickSmeltingCategory;
import de.cech12.brickfurnace.jei.BrickSmokingCategory;
import de.cech12.brickfurnace.platform.Services;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

@JeiPlugin
public class BrickFurnaceJEIPlugin
implements IModPlugin {
    private static BrickSmeltingCategory smeltingRecipeType;
    private static BrickSmokingCategory smokingRecipeType;
    private static BrickBlastingCategory blastingRecipeType;

    @Nonnull
    public class_2960 getPluginUid() {
        return Constants.id("plugin_brickfurnace");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        smeltingRecipeType = new BrickSmeltingCategory(guiHelper);
        smokingRecipeType = new BrickSmokingCategory(guiHelper);
        blastingRecipeType = new BrickBlastingCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{smeltingRecipeType, smokingRecipeType, blastingRecipeType});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        MinecraftServer server = BrickFurnaceMod.getServer();
        if (server != null) {
            class_10289 recipeMap = server.method_3772().field_54638;
            registration.addRecipes(smeltingRecipeType.getRecipeType(), recipeMap.method_64698(Constants.SMELTING_RECIPE_TYPE.get()).stream().toList());
            registration.addRecipes(smokingRecipeType.getRecipeType(), recipeMap.method_64698(Constants.SMOKING_RECIPE_TYPE.get()).stream().toList());
            registration.addRecipes(blastingRecipeType.getRecipeType(), recipeMap.method_64698(Constants.BLASTING_RECIPE_TYPE.get()).stream().toList());
            if (Services.CONFIG.areVanillaRecipesEnabled()) {
                registration.addRecipes(smeltingRecipeType.getRecipeType(), recipeMap.method_64698(class_3956.field_17546).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.comp_1932().method_29177())).map(recipe -> new class_8786(recipe.comp_1932(), (class_1860)BrickSmeltingRecipe.convert((class_3861)recipe.comp_1933(), (class_5455)server.method_30611()))).collect(Collectors.toList()));
                registration.addRecipes(smokingRecipeType.getRecipeType(), recipeMap.method_64698(class_3956.field_17548).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.comp_1932().method_29177())).map(recipe -> new class_8786(recipe.comp_1932(), (class_1860)BrickSmokingRecipe.convert((class_3862)recipe.comp_1933(), (class_5455)server.method_30611()))).collect(Collectors.toList()));
                registration.addRecipes(blastingRecipeType.getRecipeType(), recipeMap.method_64698(class_3956.field_17547).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.comp_1932().method_29177())).map(recipe -> new class_8786(recipe.comp_1932(), (class_1860)BrickBlastingRecipe.convert((class_3859)recipe.comp_1933(), (class_5455)server.method_30611()))).collect(Collectors.toList()));
            }
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(smeltingRecipeType.getRecipeType(), new class_1799[]{new class_1799((class_1935)Constants.BRICK_FURNACE_BLOCK.get())});
        registration.addCraftingStation(RecipeTypes.SMELTING_FUEL, new class_1799[]{new class_1799((class_1935)Constants.BRICK_FURNACE_BLOCK.get())});
        registration.addCraftingStation(smokingRecipeType.getRecipeType(), new class_1799[]{new class_1799((class_1935)Constants.BRICK_SMOKER_BLOCK.get())});
        registration.addCraftingStation(RecipeTypes.SMOKING_FUEL, new class_1799[]{new class_1799((class_1935)Constants.BRICK_SMOKER_BLOCK.get())});
        registration.addCraftingStation(blastingRecipeType.getRecipeType(), new class_1799[]{new class_1799((class_1935)Constants.BRICK_BLAST_FURNACE_BLOCK.get())});
        registration.addCraftingStation(RecipeTypes.BLASTING_FUEL, new class_1799[]{new class_1799((class_1935)Constants.BRICK_BLAST_FURNACE_BLOCK.get())});
    }
}

