/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.jei;

import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.crafting.BrickBlastingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmeltingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmokingRecipe;
import de.cech12.brickfurnace.jei.BrickBlastingCategory;
import de.cech12.brickfurnace.jei.BrickSmeltingCategory;
import de.cech12.brickfurnace.jei.BrickSmokingCategory;
import de.cech12.brickfurnace.platform.Services;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@JeiPlugin
public class BrickFurnaceJEIPlugin
implements IModPlugin {
    private static BrickSmeltingCategory smeltingRecipeType;
    private static BrickSmokingCategory smokingRecipeType;
    private static BrickBlastingCategory blastingRecipeType;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return Constants.id("plugin_brickfurnace");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        smeltingRecipeType = new BrickSmeltingCategory(guiHelper);
        smokingRecipeType = new BrickSmokingCategory(guiHelper);
        blastingRecipeType = new BrickBlastingCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{smeltingRecipeType, smokingRecipeType, blastingRecipeType});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            RecipeMap recipeMap = server.getRecipeManager().recipeMap();
            registration.addRecipes(smeltingRecipeType.getRecipeType(), recipeMap.byType(Constants.SMELTING_RECIPE_TYPE.get()).stream().toList());
            registration.addRecipes(smokingRecipeType.getRecipeType(), recipeMap.byType(Constants.SMOKING_RECIPE_TYPE.get()).stream().toList());
            registration.addRecipes(blastingRecipeType.getRecipeType(), recipeMap.byType(Constants.BLASTING_RECIPE_TYPE.get()).stream().toList());
            if (Services.CONFIG.areVanillaRecipesEnabled()) {
                registration.addRecipes(smeltingRecipeType.getRecipeType(), recipeMap.byType(RecipeType.SMELTING).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id().location())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)BrickSmeltingRecipe.convert((SmeltingRecipe)recipe.value(), (RegistryAccess)server.registryAccess()))).collect(Collectors.toList()));
                registration.addRecipes(smokingRecipeType.getRecipeType(), recipeMap.byType(RecipeType.SMOKING).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id().location())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)BrickSmokingRecipe.convert((SmokingRecipe)recipe.value(), (RegistryAccess)server.registryAccess()))).collect(Collectors.toList()));
                registration.addRecipes(blastingRecipeType.getRecipeType(), recipeMap.byType(RecipeType.BLASTING).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id().location())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)BrickBlastingRecipe.convert((BlastingRecipe)recipe.value(), (RegistryAccess)server.registryAccess()))).collect(Collectors.toList()));
            }
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(smeltingRecipeType.getRecipeType(), new ItemStack[]{new ItemStack((ItemLike)Constants.BRICK_FURNACE_BLOCK.get())});
        registration.addCraftingStation(RecipeTypes.SMELTING_FUEL, new ItemStack[]{new ItemStack((ItemLike)Constants.BRICK_FURNACE_BLOCK.get())});
        registration.addCraftingStation(smokingRecipeType.getRecipeType(), new ItemStack[]{new ItemStack((ItemLike)Constants.BRICK_SMOKER_BLOCK.get())});
        registration.addCraftingStation(RecipeTypes.SMOKING_FUEL, new ItemStack[]{new ItemStack((ItemLike)Constants.BRICK_SMOKER_BLOCK.get())});
        registration.addCraftingStation(blastingRecipeType.getRecipeType(), new ItemStack[]{new ItemStack((ItemLike)Constants.BRICK_BLAST_FURNACE_BLOCK.get())});
        registration.addCraftingStation(RecipeTypes.BLASTING_FUEL, new ItemStack[]{new ItemStack((ItemLike)Constants.BRICK_BLAST_FURNACE_BLOCK.get())});
    }
}

