/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.rei;

import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.crafting.BrickBlastingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmeltingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmokingRecipe;
import de.cech12.brickfurnace.platform.Services;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.forge.REIPluginCommon;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@REIPluginCommon
public class BrickFurnaceReiCommonPlugin
implements REICommonPlugin {
    public static final CategoryIdentifier<DefaultCookingDisplay> SMELTING_ID = CategoryIdentifier.of((String)"brickfurnace", (String)"smelting");
    public static final CategoryIdentifier<DefaultCookingDisplay> SMOKING_ID = CategoryIdentifier.of((String)"brickfurnace", (String)"smoking");
    public static final CategoryIdentifier<DefaultCookingDisplay> BLASTING_ID = CategoryIdentifier.of((String)"brickfurnace", (String)"blasting");

    public void registerDisplays(ServerDisplayRegistry registry) {
        registry.beginRecipeFiller(BrickSmeltingRecipe.class).filterType(Constants.SMELTING_RECIPE_TYPE.get()).fill(BrickSmeltingDisplay::new);
        registry.beginRecipeFiller(BrickSmokingRecipe.class).filterType(Constants.SMOKING_RECIPE_TYPE.get()).fill(BrickSmokingDisplay::new);
        registry.beginRecipeFiller(BrickBlastingRecipe.class).filterType(Constants.BLASTING_RECIPE_TYPE.get()).fill(BrickBlastingDisplay::new);
        if (Services.CONFIG.areVanillaRecipesEnabled()) {
            registry.beginRecipeFiller(SmeltingRecipe.class).filterType(RecipeType.SMELTING).filter(recipeHolder -> Services.CONFIG.isRecipeAllowed(recipeHolder.id().location())).fill(BrickSmeltingDisplay::new);
            registry.beginRecipeFiller(SmokingRecipe.class).filterType(RecipeType.SMOKING).filter(recipeHolder -> Services.CONFIG.isRecipeAllowed(recipeHolder.id().location())).fill(BrickSmokingDisplay::new);
            registry.beginRecipeFiller(BlastingRecipe.class).filterType(RecipeType.BLASTING).filter(recipeHolder -> Services.CONFIG.isRecipeAllowed(recipeHolder.id().location())).fill(BrickBlastingDisplay::new);
        }
    }

    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(Constants.id("smelting"), BrickSmeltingDisplay.SERIALIZER);
        registry.register(Constants.id("smoking"), BrickSmokingDisplay.SERIALIZER);
        registry.register(Constants.id("blasting"), BrickBlastingDisplay.SERIALIZER);
    }

    static class BrickSmeltingDisplay
    extends DefaultCookingDisplay {
        public static DisplaySerializer<BrickSmeltingDisplay> SERIALIZER = BrickSmeltingDisplay.serializer(BrickSmeltingDisplay::new);

        public BrickSmeltingDisplay(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
            super(List.of(EntryIngredients.ofIngredient((Ingredient)((AbstractCookingRecipe)recipe.value()).input())), List.of(EntryIngredients.of((ItemStack)((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(new ItemStack((ItemLike)((Holder)((AbstractCookingRecipe)recipe.value()).input().items().findFirst().get()).value())), null))), Optional.of(recipe.id().location()), ((AbstractCookingRecipe)recipe.value()).experience(), recipe.value() instanceof BrickSmeltingRecipe ? (double)((AbstractCookingRecipe)recipe.value()).cookingTime() : (double)((AbstractCookingRecipe)recipe.value()).cookingTime() * Services.CONFIG.getCookTimeFactor());
        }

        public BrickSmeltingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> id, float xp, double cookTime) {
            super(input, output, id, xp, cookTime);
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return SMELTING_ID;
        }

        @Nullable
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    static class BrickSmokingDisplay
    extends DefaultCookingDisplay {
        public static DisplaySerializer<BrickSmokingDisplay> SERIALIZER = BrickSmokingDisplay.serializer(BrickSmokingDisplay::new);

        public BrickSmokingDisplay(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
            super(List.of(EntryIngredients.ofIngredient((Ingredient)((AbstractCookingRecipe)recipe.value()).input())), List.of(EntryIngredients.of((ItemStack)((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(new ItemStack((ItemLike)((Holder)((AbstractCookingRecipe)recipe.value()).input().items().findFirst().get()).value())), null))), Optional.of(recipe.id().location()), ((AbstractCookingRecipe)recipe.value()).experience(), recipe.value() instanceof BrickSmokingRecipe ? (double)((AbstractCookingRecipe)recipe.value()).cookingTime() : (double)((AbstractCookingRecipe)recipe.value()).cookingTime() * Services.CONFIG.getCookTimeFactor());
        }

        public BrickSmokingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> id, float xp, double cookTime) {
            super(input, output, id, xp, cookTime);
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return SMOKING_ID;
        }

        @Nullable
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    static class BrickBlastingDisplay
    extends DefaultCookingDisplay {
        public static DisplaySerializer<BrickBlastingDisplay> SERIALIZER = BrickBlastingDisplay.serializer(BrickBlastingDisplay::new);

        public BrickBlastingDisplay(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
            super(List.of(EntryIngredients.ofIngredient((Ingredient)((AbstractCookingRecipe)recipe.value()).input())), List.of(EntryIngredients.of((ItemStack)((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(new ItemStack((ItemLike)((Holder)((AbstractCookingRecipe)recipe.value()).input().items().findFirst().get()).value())), null))), Optional.of(recipe.id().location()), ((AbstractCookingRecipe)recipe.value()).experience(), recipe.value() instanceof BrickBlastingRecipe ? (double)((AbstractCookingRecipe)recipe.value()).cookingTime() : (double)((AbstractCookingRecipe)recipe.value()).cookingTime() * Services.CONFIG.getCookTimeFactor());
        }

        public BrickBlastingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> id, float xp, double cookTime) {
            super(input, output, id, xp, cookTime);
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return BLASTING_ID;
        }

        @Nullable
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

