/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.fnp_patcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class PKMain {
    public static List<File> getJarFiles(Path dir) {
        List<File> list;
        block8: {
            Stream<Path> files = Files.list(dir);
            try {
                list = files.filter(path -> !path.toString().contains("fnp_patcher") && path.toString().endsWith(".jar") && path.toFile().isFile()).map(Path::toFile).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return List.of();
                }
            }
            files.close();
        }
        return list;
    }

    private static File findTargetJar() throws IOException {
        Path currentDir = new File("").toPath();
        List<File> jarFiles = PKMain.getJarFiles(currentDir);
        if (jarFiles != null) {
            for (File jar : jarFiles) {
                try (JarFile jarFile = new JarFile(jar);){
                    if (jarFile.getEntry("krypton.mixins.json") == null) continue;
                    File file = jar;
                    return file;
                }
            }
        }
        return null;
    }

    private static void patchJarFiles(File targetJar) throws IOException {
        File currentJar;
        String jarPath = PKMain.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            URI uri = PKMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            currentJar = Paths.get(uri).toFile();
        }
        catch (Exception e) {
            currentJar = new File(jarPath);
        }
        File tempFile = new File(targetJar.getParent(), targetJar.getName() + ".tmp");
        try (JarFile sourceJar = new JarFile(currentJar);
             JarFile originalJar = new JarFile(targetJar);
             JarOutputStream jos = new JarOutputStream(new FileOutputStream(tempFile));){
            originalJar.stream().forEach(entry -> {
                try {
                    if (!entry.getName().startsWith("META-INF/jars/")) {
                        jos.putNextEntry(new JarEntry(entry.getName()));
                        originalJar.getInputStream((ZipEntry)entry).transferTo(jos);
                        jos.closeEntry();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            sourceJar.stream().filter(entry -> entry.getName().startsWith("META-INF/jars/")).forEach(entry -> {
                try {
                    jos.putNextEntry(new JarEntry(entry.getName()));
                    sourceJar.getInputStream((ZipEntry)entry).transferTo(jos);
                    jos.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Files.move(tempFile.toPath(), targetJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void main(String[] args) {
        try {
            File targetJar = PKMain.findTargetJar();
            if (targetJar != null) {
                PKMain.patchJarFiles(targetJar);
                System.out.println("Successfully patched " + targetJar.getName());
            } else {
                System.out.println("No suitable target JAR found");
            }
        }
        catch (IOException e) {
            System.err.println("Error during patching: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

