/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.fnp_patcher;

import de.bsommerfeld.jshepherd.annotation.Comment;
import de.bsommerfeld.jshepherd.annotation.Key;
import de.bsommerfeld.jshepherd.core.ConfigurablePojo;
import de.bsommerfeld.jshepherd.core.ConfigurationLoader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig
extends ConfigurablePojo<ModConfig> {
    public static final ModConfig INSTANCE = ModConfig.init();
    @Key(value="fix-issues128-enabled")
    @Comment(value={"Fix Traffic Statistics"})
    private boolean issues128 = false;
    @Key(value="fix-issues128-sync")
    @Comment(value={"Run bandwidth statistics on sync thread, which is closer to Vanilla behavior."})
    private boolean issues128Sync = true;
    @Key(value="mixin-loginVT")
    @Comment(value={"Replace player login validation thread with virtual thread"})
    private boolean loginVT = true;
    @Key(value="mixin-textFilterVT")
    @Comment(value={"Replace text filter thread with virtual thread"})
    private boolean textFilterVT = true;
    @Key(value="mixin-utilVT")
    @Comment(value={"Replace download thread with virtual thread"})
    private boolean utilVT = true;
    @Key(value="mixin-bestVarLong")
    @Comment(value={"Optimized VarLong implementation"})
    private boolean bestVarLong = true;

    private static ModConfig init() {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("krypton_fnp.yaml");
        ModConfig config = (ModConfig)ConfigurationLoader.load((Path)configFile, ModConfig::new);
        config.save();
        config.reload();
        return config;
    }

    public boolean isIssues128() {
        return this.issues128;
    }

    public boolean isIssues128Sync() {
        return this.issues128Sync;
    }

    public boolean isLoginVT() {
        return this.loginVT;
    }

    public boolean isTextFilterVT() {
        return this.textFilterVT;
    }

    public boolean isUtilVT() {
        return this.utilVT;
    }

    public boolean isBestVarLong() {
        return this.bestVarLong;
    }
}

