/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.fnp_patcher.mixin;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import one.pkg.fnp_patcher.ModConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class KryptonFNPMixinBootstrap
implements IMixinConfigPlugin {
    private final Logger logger = LoggerFactory.getLogger((String)"KryptonFNPMixinBootstrap");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        CONFIG config = CONFIG.find(mixinClassName);
        if (config != null) {
            boolean b = config.isEnabled();
            this.logger.info("Mixin {} {} {}", new Object[]{mixinClassName, b ? "enabled" : "disabled", config.ENV});
            return b;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static enum CONFIG {
        Login_VT("one.pkg.fnp_patcher.mixin.network.experimental.ServerLoginPacketListenerImplMixin", "krypton.loginVT", CONFIG.getField("loginVT")),
        TextFilter_VT("one.pkg.fnp_patcher.mixin.network.experimental.ServerTextFilterMixin", "krypton.textFilterVT", CONFIG.getField("textFilterVT")),
        Util_VT("one.pkg.fnp_patcher.mixin.network.experimental.UtilMixin", "krypton.utilVT", CONFIG.getField("utilVT")),
        BestVarLong("one.pkg.fnp_patcher.mixin.network.experimental.VarLongMixin", "krypton.bestVarLong", CONFIG.getField("bestVarLong")),
        KryptonFix128("one.pkg.fnp_patcher.mixin.network.fix.Varint21FrameDecoderMixin", "krypton.fix128", CONFIG.getField("issues128"), "krypton");

        public final String CLASS;
        public final String ENV;
        public final boolean hasMod;
        public final Field configTarget;

        private CONFIG(@Nullable String clazz, String env, Field configTarget) {
            this(clazz, env, configTarget, null);
        }

        private CONFIG(@Nullable String clazz, @NotNull String env, Field configTarget, String modid) {
            this.CLASS = clazz;
            this.ENV = env;
            this.configTarget = configTarget;
            this.hasMod = modid != null ? FabricLoader.getInstance().isModLoaded(modid) : true;
        }

        private static Field getField(@NotNull String fieldName) {
            try {
                Field field = ((Object)((Object)ModConfig.INSTANCE)).getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        private static Object getFieldValue(@NotNull Field field) {
            try {
                return field.get((Object)ModConfig.INSTANCE);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        private static boolean getBooleanValue(@NotNull Field field) {
            Object value = CONFIG.getFieldValue(field);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return b;
            }
            if (value instanceof String) {
                String s = (String)value;
                return Boolean.parseBoolean(s);
            }
            return false;
        }

        @Nullable
        public static CONFIG find(String clazz) {
            for (CONFIG config : CONFIG.values()) {
                if (!config.CLASS.equals(clazz)) continue;
                return config;
            }
            return null;
        }

        public boolean isEnabled() {
            return this.hasMod && (CONFIG.getBooleanValue(this.configTarget) || Boolean.parseBoolean(System.getProperty(this.ENV, "true")));
        }
    }
}

