/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingpixel.cobbleutils.api.PermissionApi;
import com.kingpixel.cobbleutils.util.Utils;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypeAdapter;
import com.kingpixel.ultrashop.adapters.ShopTypeCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicWeekly;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.adapters.ShopTypeWeekly;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.config.Lang;
import com.kingpixel.ultrashop.database.DataBaseFactory;
import com.kingpixel.ultrashop.models.DataShop;
import com.kingpixel.ultrashop.models.Shop;
import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class UltraShop
implements ModInitializer {
    public static final String MOD_ID = "ultrashop";
    public static final String MOD_NAME = "UltraShop";
    public static final String PATH = "/config/ultrashop/";
    public static final String PATH_SHOP = "/config/ultrashop/shop/";
    public static final String PATH_LANG = "/config/ultrashop/lang/";
    public static final String PATH_MIGRATION = "/config/ultrashop/migration/";
    public static final String PATH_BACKUP_MIGRATION = "/config/ultrashop/backup_migration/";
    public static final String PATH_DATA = "/config/ultrashop/data/";
    public static final String PATH_DATA_USERS = "/config/ultrashop/data/users/";
    public static MinecraftServer server;
    public static ShopOptionsApi options;
    public static Lang lang;
    public static Gson gson;
    public static Gson gsonWithOutSpaces;
    public static DataShop dataShop;
    public static ExecutorService SHOP_EXECUTOR;

    private static GsonBuilder addAdapters(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(ShopType.class, (Object)ShopTypeAdapter.INSTANCE).registerTypeAdapter(ShopTypePermanent.class, (Object)ShopTypePermanent.INSTANCE).registerTypeAdapter(ShopTypeDynamic.class, (Object)ShopTypeDynamic.INSTANCE).registerTypeAdapter(ShopTypeWeekly.class, (Object)ShopTypeWeekly.INSTANCE).registerTypeAdapter(ShopTypeDynamicWeekly.class, (Object)ShopTypeDynamicWeekly.INSTANCE).registerTypeAdapter(ShopTypeCalendar.class, (Object)ShopTypeCalendar.INSTANCE).registerTypeAdapter(ShopTypeDynamicCalendar.class, (Object)ShopTypeDynamicCalendar.INSTANCE);
    }

    public void onInitialize() {
        gson = UltraShop.addAdapters(Utils.newGson().newBuilder()).create();
        gsonWithOutSpaces = UltraShop.addAdapters(Utils.newWithoutSpacingGson().newBuilder()).create();
        options = ShopOptionsApi.builder().modId(MOD_ID).path(PATH).build();
        UltraShop.events();
    }

    public static void load(ShopOptionsApi options) {
        ShopApi.register(options, (CommandDispatcher<class_2168>)server.method_3734().method_9235());
        dataShop.init();
        new DataBaseFactory(ShopApi.getMainConfig().getDataBase());
    }

    public static void events() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(level -> {
            server = level.method_8503();
            class_2168 source = server.method_3739();
            ShopApi.shops.forEach((modId, list) -> list.forEach(shop -> PermissionApi.hasPermission((class_2168)source, (String)shop.getPermission(ShopOptionsApi.builder().modId((String)modId).build()), (int)4)));
        });
        CommandRegistrationEvent.EVENT.register((dispatcher, commandRegistryAccess, registrationEnvironment) -> {
            ShopApi.register(options, (CommandDispatcher<class_2168>)dispatcher);
            dataShop.init();
            new DataBaseFactory(ShopApi.getMainConfig().getDataBase());
        });
        PlayerEvent.PLAYER_JOIN.register(player -> CompletableFuture.runAsync(() -> DataBaseFactory.INSTANCE.getUserInfo(player), SHOP_EXECUTOR));
        PlayerEvent.PLAYER_QUIT.register(player -> {
            DataBaseFactory.INSTANCE.removeIfNecessary(player);
            ShopApi.sellLock.remove(player.method_5667());
        });
    }

    public static void initSellProduct(ShopOptionsApi options) {
        ShopApi.sellProducts = ShopApi.shops.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(shop -> shop, shop -> shop.getType().getProducts((Shop)shop, options).stream().filter(product -> product.canSell(null, (Shop)shop, options)).collect(Collectors.toList())));
    }

    static {
        lang = new Lang();
        dataShop = new DataShop();
        SHOP_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CobbleShop-Executor-%d").build());
    }
}

