/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.kingpixel.ultrashop.adapters.ShopTypeCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicWeekly;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.adapters.ShopTypeWeekly;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.config.Config;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.util.List;
import java.util.Stack;
import lombok.Generated;
import net.minecraft.class_3222;

public abstract class ShopType {
    private TypeShop typeShop;

    public static ShopType get(String type) {
        return switch (TypeShop.valueOf(type)) {
            case TypeShop.DYNAMIC -> new ShopTypeDynamic();
            case TypeShop.DYNAMIC_WEEKLY -> new ShopTypeDynamicWeekly();
            case TypeShop.PERMANENT -> new ShopTypePermanent();
            case TypeShop.WEEKLY -> new ShopTypeWeekly();
            case TypeShop.DYNAMIC_CALENDAR -> new ShopTypeDynamicCalendar();
            case TypeShop.CALENDAR -> new ShopTypeCalendar();
            default -> new ShopTypePermanent();
        };
    }

    public List<Product> getProducts(Shop shop, ShopOptionsApi options) {
        return shop.getProducts();
    }

    public void check() {
        if (this.typeShop == null) {
            this.typeShop = TypeShop.PERMANENT;
        }
    }

    public boolean isOpen() {
        return true;
    }

    public String replace(String text, ShopOptionsApi shopOptionsApi, Shop shop) {
        return "";
    }

    public abstract String replace(String var1, Shop var2, ShopOptionsApi var3);

    public boolean buyProduct(class_3222 player, Product product, Shop shop, int amount, ShopOptionsApi options, Config config, Stack<Shop> stack, boolean withClose) {
        return product.buy(player, shop, amount, options, config, stack, withClose);
    }

    @Generated
    public TypeShop getTypeShop() {
        return this.typeShop;
    }

    @Generated
    public void setTypeShop(TypeShop typeShop) {
        this.typeShop = typeShop;
    }

    @Generated
    public String toString() {
        return "ShopType(typeShop=" + String.valueOf((Object)this.getTypeShop()) + ")";
    }
}

