/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypeCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamicWeekly;
import com.kingpixel.ultrashop.adapters.ShopTypePermanent;
import com.kingpixel.ultrashop.adapters.ShopTypeWeekly;
import com.kingpixel.ultrashop.models.TypeShop;
import java.lang.reflect.Type;

public class ShopTypeAdapter
implements JsonDeserializer<ShopType> {
    public static ShopTypeAdapter INSTANCE = new ShopTypeAdapter();

    public ShopType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement typeShopElement = jsonObject.get("typeShop");
        if (typeShopElement == null || typeShopElement.getAsString().isEmpty()) {
            throw new JsonParseException("Missing or empty 'typeShop' field");
        }
        String typeShop = typeShopElement.getAsString();
        return switch (TypeShop.valueOf(typeShop)) {
            case TypeShop.PERMANENT -> (ShopType)context.deserialize((JsonElement)jsonObject, ShopTypePermanent.class);
            case TypeShop.DYNAMIC -> (ShopType)context.deserialize((JsonElement)jsonObject, ShopTypeDynamic.class);
            case TypeShop.WEEKLY -> (ShopType)context.deserialize((JsonElement)jsonObject, ShopTypeWeekly.class);
            case TypeShop.DYNAMIC_WEEKLY -> (ShopType)context.deserialize((JsonElement)jsonObject, ShopTypeDynamicWeekly.class);
            case TypeShop.CALENDAR -> (ShopType)context.deserialize((JsonElement)jsonObject, ShopTypeCalendar.class);
            case TypeShop.DYNAMIC_CALENDAR -> (ShopType)context.deserialize((JsonElement)jsonObject, ShopTypeDynamicCalendar.class);
            default -> throw new JsonParseException("Unknown type: " + typeShop);
        };
    }
}

