/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.DateRange;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ShopTypeCalendar
extends ShopType
implements JsonSerializer<ShopTypeCalendar>,
JsonDeserializer<ShopTypeCalendar> {
    public static ShopTypeCalendar INSTANCE = new ShopTypeCalendar();
    private List<DateRange> dateRanges;

    public ShopTypeCalendar() {
        this.setTypeShop(TypeShop.CALENDAR);
        this.dateRanges = List.of(new DateRange(LocalDate.now(), LocalDate.now().plusWeeks(1L)));
    }

    public ShopTypeCalendar(List<DateRange> dateRanges) {
        this.setTypeShop(TypeShop.CALENDAR);
        this.dateRanges = dateRanges;
    }

    @Override
    public void check() {
        this.setTypeShop(TypeShop.CALENDAR);
        if (this.dateRanges == null || this.dateRanges.isEmpty()) {
            this.dateRanges = List.of(new DateRange(LocalDate.now(), LocalDate.now().plusWeeks(1L)));
        }
    }

    @Override
    public boolean isOpen() {
        return ShopTypeCalendar.canEnterDate(this.dateRanges);
    }

    public static boolean canEnterDate(List<DateRange> dateRanges) {
        LocalDate today = LocalDate.now();
        for (DateRange range : dateRanges) {
            if (today.isBefore(range.getStartDate()) || today.isAfter(range.getEndDate())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String replace(String text, Shop shop, ShopOptionsApi shopOptionsApi) {
        return text;
    }

    public JsonElement serialize(ShopTypeCalendar src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        JsonArray dateRangesArray = new JsonArray();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        for (DateRange range : src.getDateRanges()) {
            JsonObject rangeObject = new JsonObject();
            rangeObject.addProperty("startDate", range.getStartDate().format(formatter));
            rangeObject.addProperty("endDate", range.getEndDate().format(formatter));
            dateRangesArray.add((JsonElement)rangeObject);
        }
        jsonObject.add("dateRanges", (JsonElement)dateRangesArray);
        jsonObject.addProperty("typeShop", src.getTypeShop().toString());
        return jsonObject;
    }

    public ShopTypeCalendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonArray dateRangesArray = jsonObject.getAsJsonArray("dateRanges");
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        if (dateRangesArray != null) {
            for (JsonElement rangeElement : dateRangesArray) {
                JsonObject rangeObject = rangeElement.getAsJsonObject();
                LocalDate startDate = LocalDate.parse(rangeObject.get("startDate").getAsString(), formatter);
                LocalDate endDate = LocalDate.parse(rangeObject.get("endDate").getAsString(), formatter);
                dateRanges.add(new DateRange(startDate, endDate));
            }
        } else {
            LocalDate today = LocalDate.now();
            dateRanges.add(new DateRange(today, today.plusWeeks(1L)));
        }
        ShopTypeCalendar shopTypeCalendar = new ShopTypeCalendar(dateRanges);
        shopTypeCalendar.setTypeShop(TypeShop.valueOf(jsonObject.get("typeShop").getAsString()));
        return shopTypeCalendar;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShopTypeCalendar)) {
            return false;
        }
        ShopTypeCalendar other = (ShopTypeCalendar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DateRange> this$dateRanges = this.getDateRanges();
        List<DateRange> other$dateRanges = other.getDateRanges();
        return !(this$dateRanges == null ? other$dateRanges != null : !((Object)this$dateRanges).equals(other$dateRanges));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShopTypeCalendar;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DateRange> $dateRanges = this.getDateRanges();
        result = result * 59 + ($dateRanges == null ? 43 : ((Object)$dateRanges).hashCode());
        return result;
    }

    @Generated
    public List<DateRange> getDateRanges() {
        return this.dateRanges;
    }

    @Generated
    public void setDateRanges(List<DateRange> dateRanges) {
        this.dateRanges = dateRanges;
    }

    @Override
    @Generated
    public String toString() {
        return "ShopTypeCalendar(dateRanges=" + String.valueOf(this.getDateRanges()) + ")";
    }
}

