/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;

public class ShopTypeDynamic
extends ShopType
implements JsonSerializer<ShopTypeDynamic>,
JsonDeserializer<ShopTypeDynamic> {
    public static ShopTypeDynamic INSTANCE = new ShopTypeDynamic();
    private int cooldown;
    private int productsRotation;

    public ShopTypeDynamic() {
        this.setTypeShop(TypeShop.DYNAMIC);
        this.cooldown = 30;
        this.productsRotation = 3;
    }

    public ShopTypeDynamic(int cooldown, int productsRotation) {
        this.setTypeShop(TypeShop.DYNAMIC);
        this.cooldown = cooldown;
        this.productsRotation = productsRotation;
    }

    @Override
    public void check() {
        this.setTypeShop(TypeShop.DYNAMIC);
        this.cooldown = Math.max(1, this.cooldown);
        this.productsRotation = Math.max(1, this.productsRotation);
    }

    @Override
    public List<Product> getProducts(Shop shop, ShopOptionsApi options) {
        return ShopTypeDynamic.getDynamicProducts(shop, options);
    }

    public static List<Product> getDynamicProducts(Shop shop, ShopOptionsApi options) {
        return UltraShop.dataShop.updateDynamicProducts(shop, options);
    }

    @Override
    public String replace(String text, Shop shop, ShopOptionsApi shopOptionsApi) {
        return text.replace("%cooldown%", PlayerUtils.getCooldown((long)UltraShop.dataShop.getActualCooldown(shop, shopOptionsApi))).replace("%number%", String.valueOf(this.getProductsRotation())).replace("%amountProducts%", String.valueOf(this.getProductsRotation()));
    }

    public JsonElement serialize(ShopTypeDynamic src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("typeShop", src.getTypeShop().toString());
        jsonObject.addProperty("cooldown", (Number)src.getCooldown());
        jsonObject.addProperty("productsRotation", (Number)src.getProductsRotation());
        return jsonObject;
    }

    public ShopTypeDynamic deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement jsonCooldown = jsonObject.get("cooldown");
        int cooldown = jsonCooldown != null ? jsonCooldown.getAsInt() : 30;
        JsonElement jsonProductsRotation = jsonObject.get("productsRotation");
        int productsRotation = jsonProductsRotation != null ? jsonProductsRotation.getAsInt() : 3;
        ShopTypeDynamic shopTypeDynamic = new ShopTypeDynamic(cooldown, productsRotation);
        shopTypeDynamic.setTypeShop(TypeShop.valueOf(jsonObject.get("typeShop").getAsString()));
        return shopTypeDynamic;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShopTypeDynamic)) {
            return false;
        }
        ShopTypeDynamic other = (ShopTypeDynamic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCooldown() != other.getCooldown()) {
            return false;
        }
        return this.getProductsRotation() == other.getProductsRotation();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShopTypeDynamic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCooldown();
        result = result * 59 + this.getProductsRotation();
        return result;
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }

    @Generated
    public int getProductsRotation() {
        return this.productsRotation;
    }

    @Generated
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setProductsRotation(int productsRotation) {
        this.productsRotation = productsRotation;
    }

    @Override
    @Generated
    public String toString() {
        return "ShopTypeDynamic(cooldown=" + this.getCooldown() + ", productsRotation=" + this.getProductsRotation() + ")";
    }
}

