/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypeCalendar;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.DateRange;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ShopTypeDynamicCalendar
extends ShopType
implements JsonSerializer<ShopTypeDynamicCalendar>,
JsonDeserializer<ShopTypeDynamicCalendar> {
    public static ShopTypeDynamicCalendar INSTANCE = new ShopTypeDynamicCalendar();
    private List<DateRange> dateRanges;
    private int cooldown;
    private int productsRotation;

    public ShopTypeDynamicCalendar() {
        this.setTypeShop(TypeShop.DYNAMIC_CALENDAR);
        this.dateRanges = List.of(new DateRange(LocalDate.now(), LocalDate.now().plusWeeks(1L)));
        this.cooldown = 30;
        this.productsRotation = 3;
    }

    public ShopTypeDynamicCalendar(List<DateRange> dateRanges) {
        this.setTypeShop(TypeShop.DYNAMIC_CALENDAR);
        this.dateRanges = dateRanges;
        this.cooldown = 30;
        this.productsRotation = 3;
    }

    @Override
    public void check() {
        this.setTypeShop(TypeShop.DYNAMIC_CALENDAR);
        if (this.dateRanges == null || this.dateRanges.isEmpty()) {
            this.dateRanges = List.of(new DateRange(LocalDate.now(), LocalDate.now().plusWeeks(1L)));
        }
    }

    @Override
    public List<Product> getProducts(Shop shop, ShopOptionsApi options) {
        return ShopTypeDynamic.getDynamicProducts(shop, options);
    }

    @Override
    public boolean isOpen() {
        return ShopTypeCalendar.canEnterDate(this.dateRanges);
    }

    @Override
    public String replace(String text, Shop shop, ShopOptionsApi shopOptionsApi) {
        return text.replace("%cooldown%", PlayerUtils.getCooldown((long)UltraShop.dataShop.getActualCooldown(shop, shopOptionsApi))).replace("%number%", String.valueOf(this.getProductsRotation())).replace("%amountProducts%", String.valueOf(this.getProductsRotation()));
    }

    public JsonElement serialize(ShopTypeDynamicCalendar src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        JsonArray dateRangesArray = new JsonArray();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        for (DateRange range : src.getDateRanges()) {
            JsonObject rangeObject = new JsonObject();
            rangeObject.addProperty("startDate", range.getStartDate().format(formatter));
            rangeObject.addProperty("endDate", range.getEndDate().format(formatter));
            dateRangesArray.add((JsonElement)rangeObject);
        }
        jsonObject.add("dateRanges", (JsonElement)dateRangesArray);
        jsonObject.addProperty("cooldown", (Number)src.getCooldown());
        jsonObject.addProperty("productsRotation", (Number)src.getProductsRotation());
        jsonObject.addProperty("typeShop", src.getTypeShop().toString());
        return jsonObject;
    }

    public ShopTypeDynamicCalendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonArray dateRangesArray = jsonObject.getAsJsonArray("dateRanges");
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        if (dateRangesArray != null) {
            for (JsonElement rangeElement : dateRangesArray) {
                JsonObject rangeObject = rangeElement.getAsJsonObject();
                LocalDate startDate = LocalDate.parse(rangeObject.get("startDate").getAsString(), formatter);
                LocalDate endDate = LocalDate.parse(rangeObject.get("endDate").getAsString(), formatter);
                dateRanges.add(new DateRange(startDate, endDate));
            }
        } else {
            LocalDate today = LocalDate.now();
            dateRanges.add(new DateRange(today, today.plusWeeks(1L)));
        }
        int cooldown = jsonObject.has("cooldown") ? jsonObject.get("cooldown").getAsInt() : 30;
        int productsRotation = jsonObject.has("productsRotation") ? jsonObject.get("productsRotation").getAsInt() : 3;
        ShopTypeDynamicCalendar shopTypeCalendar = new ShopTypeDynamicCalendar(dateRanges);
        shopTypeCalendar.setCooldown(cooldown);
        shopTypeCalendar.setProductsRotation(productsRotation);
        shopTypeCalendar.setTypeShop(TypeShop.valueOf(jsonObject.has("typeShop") ? jsonObject.get("typeShop").getAsString() : "DYNAMIC_CALENDAR"));
        return shopTypeCalendar;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShopTypeDynamicCalendar)) {
            return false;
        }
        ShopTypeDynamicCalendar other = (ShopTypeDynamicCalendar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCooldown() != other.getCooldown()) {
            return false;
        }
        if (this.getProductsRotation() != other.getProductsRotation()) {
            return false;
        }
        List<DateRange> this$dateRanges = this.getDateRanges();
        List<DateRange> other$dateRanges = other.getDateRanges();
        return !(this$dateRanges == null ? other$dateRanges != null : !((Object)this$dateRanges).equals(other$dateRanges));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShopTypeDynamicCalendar;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCooldown();
        result = result * 59 + this.getProductsRotation();
        List<DateRange> $dateRanges = this.getDateRanges();
        result = result * 59 + ($dateRanges == null ? 43 : ((Object)$dateRanges).hashCode());
        return result;
    }

    @Generated
    public List<DateRange> getDateRanges() {
        return this.dateRanges;
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }

    @Generated
    public int getProductsRotation() {
        return this.productsRotation;
    }

    @Generated
    public void setDateRanges(List<DateRange> dateRanges) {
        this.dateRanges = dateRanges;
    }

    @Generated
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setProductsRotation(int productsRotation) {
        this.productsRotation = productsRotation;
    }

    @Override
    @Generated
    public String toString() {
        return "ShopTypeDynamicCalendar(dateRanges=" + String.valueOf(this.getDateRanges()) + ", cooldown=" + this.getCooldown() + ", productsRotation=" + this.getProductsRotation() + ")";
    }
}

