/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingpixel.cobbleutils.util.PlayerUtils;
import com.kingpixel.ultrashop.UltraShop;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.adapters.ShopTypeDynamic;
import com.kingpixel.ultrashop.adapters.ShopTypeWeekly;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.Product;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class ShopTypeDynamicWeekly
extends ShopType
implements JsonSerializer<ShopTypeDynamicWeekly>,
JsonDeserializer<ShopTypeDynamicWeekly> {
    public static ShopTypeDynamicWeekly INSTANCE = new ShopTypeDynamicWeekly();
    private int cooldown;
    private int productsRotation;
    private List<DayOfWeek> days;

    public ShopTypeDynamicWeekly() {
        this.setTypeShop(TypeShop.DYNAMIC_WEEKLY);
        this.days = Arrays.stream(DayOfWeek.values()).toList();
        this.cooldown = 30;
        this.productsRotation = 3;
    }

    public ShopTypeDynamicWeekly(int cooldown, int productsRotation, List<DayOfWeek> days) {
        this.setTypeShop(TypeShop.DYNAMIC_WEEKLY);
        this.cooldown = cooldown;
        this.productsRotation = productsRotation;
        this.days = days;
    }

    @Override
    public void check() {
        this.setTypeShop(TypeShop.DYNAMIC_WEEKLY);
        this.cooldown = Math.max(1, this.cooldown);
        this.productsRotation = Math.max(1, this.productsRotation);
        if (this.days == null) {
            this.days = Arrays.stream(DayOfWeek.values()).toList();
        }
    }

    @Override
    public List<Product> getProducts(Shop shop, ShopOptionsApi options) {
        return ShopTypeDynamic.getDynamicProducts(shop, options);
    }

    @Override
    public boolean isOpen() {
        return ShopTypeWeekly.canEnterDay(this.days);
    }

    @Override
    public String replace(String text, Shop shop, ShopOptionsApi shopOptionsApi) {
        CharSequence[] days = (String[])this.getDays().stream().map(Enum::toString).toArray(String[]::new);
        return text.replace("%cooldown%", PlayerUtils.getCooldown((long)UltraShop.dataShop.getActualCooldown(shop, shopOptionsApi))).replace("%number%", String.valueOf(this.getProductsRotation())).replace("%amountProducts%", String.valueOf(this.getProductsRotation())).replace("%days%", String.join((CharSequence)", ", days));
    }

    public JsonElement serialize(ShopTypeDynamicWeekly src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("typeShop", src.getTypeShop().toString());
        jsonObject.addProperty("cooldown", (Number)src.getCooldown());
        jsonObject.addProperty("productsRotation", (Number)src.getProductsRotation());
        JsonArray daysArray = new JsonArray();
        for (DayOfWeek day : src.getDays()) {
            daysArray.add(day.toString());
        }
        jsonObject.add("days", (JsonElement)daysArray);
        return jsonObject;
    }

    public ShopTypeDynamicWeekly deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement jsonCooldown = jsonObject.get("cooldown");
        int cooldown = jsonCooldown != null ? jsonCooldown.getAsInt() : 30;
        JsonElement jsonProductsRotation = jsonObject.get("productsRotation");
        int productsRotation = jsonProductsRotation != null ? jsonProductsRotation.getAsInt() : 3;
        JsonArray daysArray = jsonObject.getAsJsonArray("days");
        if (daysArray == null) {
            daysArray = jsonObject.getAsJsonArray("dayOfWeek");
        }
        ArrayList<DayOfWeek> days = new ArrayList();
        if (daysArray != null) {
            for (JsonElement dayElement : daysArray) {
                days.add(DayOfWeek.valueOf(dayElement.getAsString()));
            }
        } else {
            days = Arrays.stream(DayOfWeek.values()).toList();
        }
        ShopTypeDynamicWeekly shopTypeDynamicWeekly = new ShopTypeDynamicWeekly(cooldown, productsRotation, days);
        shopTypeDynamicWeekly.setTypeShop(TypeShop.valueOf(jsonObject.get("typeShop").getAsString()));
        return shopTypeDynamicWeekly;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShopTypeDynamicWeekly)) {
            return false;
        }
        ShopTypeDynamicWeekly other = (ShopTypeDynamicWeekly)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCooldown() != other.getCooldown()) {
            return false;
        }
        if (this.getProductsRotation() != other.getProductsRotation()) {
            return false;
        }
        List<DayOfWeek> this$days = this.getDays();
        List<DayOfWeek> other$days = other.getDays();
        return !(this$days == null ? other$days != null : !((Object)this$days).equals(other$days));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShopTypeDynamicWeekly;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCooldown();
        result = result * 59 + this.getProductsRotation();
        List<DayOfWeek> $days = this.getDays();
        result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
        return result;
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }

    @Generated
    public int getProductsRotation() {
        return this.productsRotation;
    }

    @Generated
    public List<DayOfWeek> getDays() {
        return this.days;
    }

    @Generated
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setProductsRotation(int productsRotation) {
        this.productsRotation = productsRotation;
    }

    @Generated
    public void setDays(List<DayOfWeek> days) {
        this.days = days;
    }

    @Override
    @Generated
    public String toString() {
        return "ShopTypeDynamicWeekly(cooldown=" + this.getCooldown() + ", productsRotation=" + this.getProductsRotation() + ", days=" + String.valueOf(this.getDays()) + ")";
    }
}

