/*
 * Decompiled with CFR 0.152.
 */
package com.kingpixel.ultrashop.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingpixel.cobbleutils.CobbleUtils;
import com.kingpixel.ultrashop.adapters.ShopType;
import com.kingpixel.ultrashop.api.ShopApi;
import com.kingpixel.ultrashop.api.ShopOptionsApi;
import com.kingpixel.ultrashop.models.Shop;
import com.kingpixel.ultrashop.models.TypeShop;
import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class ShopTypeWeekly
extends ShopType
implements JsonSerializer<ShopTypeWeekly>,
JsonDeserializer<ShopTypeWeekly> {
    public static ShopTypeWeekly INSTANCE = new ShopTypeWeekly();
    private List<DayOfWeek> days;

    public ShopTypeWeekly() {
        this.setTypeShop(TypeShop.WEEKLY);
        this.days = Arrays.stream(DayOfWeek.values()).toList();
    }

    public ShopTypeWeekly(List<DayOfWeek> days) {
        this.setTypeShop(TypeShop.WEEKLY);
        this.days = days;
    }

    @Override
    public void check() {
        this.setTypeShop(TypeShop.WEEKLY);
        if (this.days == null) {
            this.days = Arrays.stream(DayOfWeek.values()).toList();
        }
    }

    @Override
    public boolean isOpen() {
        return ShopTypeWeekly.canEnterDay(this.days);
    }

    public static boolean canEnterDay(List<DayOfWeek> days) {
        if (days == null || days.isEmpty()) {
            return true;
        }
        if (ShopApi.getMainConfig().isDebug()) {
            CobbleUtils.LOGGER.info("Checking if shop is open today. Days: " + String.valueOf(days));
        }
        return days.contains(DayOfWeek.from(LocalDate.now()));
    }

    @Override
    public String replace(String text, Shop shop, ShopOptionsApi shopOptionsApi) {
        CharSequence[] days = (String[])this.getDays().stream().map(Enum::toString).toArray(String[]::new);
        return text.replace("%days%", String.join((CharSequence)", ", days));
    }

    public JsonElement serialize(ShopTypeWeekly src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        JsonArray daysArray = new JsonArray();
        for (DayOfWeek day : src.getDays()) {
            daysArray.add(day.toString());
        }
        jsonObject.add("days", (JsonElement)daysArray);
        jsonObject.addProperty("typeShop", src.getTypeShop().toString());
        return jsonObject;
    }

    public ShopTypeWeekly deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonArray daysArray = jsonObject.getAsJsonArray("days");
        if (daysArray == null) {
            daysArray = jsonObject.getAsJsonArray("dayOfWeek");
        }
        ArrayList<DayOfWeek> days = new ArrayList();
        if (daysArray != null) {
            for (JsonElement dayElement : daysArray) {
                days.add(DayOfWeek.valueOf(dayElement.getAsString()));
            }
        } else {
            days = Arrays.stream(DayOfWeek.values()).toList();
        }
        ShopTypeWeekly shopTypeWeekly = new ShopTypeWeekly(days);
        shopTypeWeekly.setTypeShop(TypeShop.valueOf(jsonObject.get("typeShop").getAsString()));
        return shopTypeWeekly;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShopTypeWeekly)) {
            return false;
        }
        ShopTypeWeekly other = (ShopTypeWeekly)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DayOfWeek> this$days = this.getDays();
        List<DayOfWeek> other$days = other.getDays();
        return !(this$days == null ? other$days != null : !((Object)this$days).equals(other$days));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShopTypeWeekly;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DayOfWeek> $days = this.getDays();
        result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
        return result;
    }

    @Generated
    public List<DayOfWeek> getDays() {
        return this.days;
    }

    @Generated
    public void setDays(List<DayOfWeek> days) {
        this.days = days;
    }

    @Override
    @Generated
    public String toString() {
        return "ShopTypeWeekly(days=" + String.valueOf(this.getDays()) + ")";
    }
}

